/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.base.markdown;

import com.google.common.base.Splitter;
import com.petebevin.markdown.MarkdownProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.wicket.util.string.Strings;

public class Markdown {
    public static String markdownToHtml(String markdown) {
        MarkdownProcessor processor = new MarkdownProcessor();
        String text = processor.markdown(markdown);
        text = Markdown.processLiquidTags(text);
        return text;
    }

    private static String processLiquidTags(String text) {
        StringBuilder sb = new StringBuilder();
        int previousStart = 0;
        int start = text.indexOf("{% ");
        while (start > 0) {
            int end = text.indexOf("{% end", start);
            end = text.indexOf("%}", end + 5) + 2;
            sb.append(text.substring(previousStart, start));
            String block = text.substring(start, end);
            if (block.startsWith("{% highlight")) {
                sb.append(Markdown.handleCodeBlock(block));
            }
            if (block.startsWith("{% alert")) {
                sb.append(Markdown.handleAlert(block));
            }
            sb.append("\n");
            previousStart = end;
            start = text.indexOf("{% ", end);
        }
        if (previousStart < text.length()) {
            sb.append(text.substring(previousStart));
        }
        String markup = sb.toString();
        return markup;
    }

    private static String handleCodeBlock(String codeblock) {
        codeblock = codeblock.replaceAll("\\{\\% highlight (.+) \\%\\}", "<pre class=\"prettyprint linenums\" lang=\"$1\">");
        codeblock = codeblock.replaceAll("\\{\\% endhighlight \\%\\}", "</pre>");
        int start = codeblock.indexOf(">") + 1;
        int end = codeblock.indexOf("</pre>");
        String result = codeblock.substring(start, end);
        result = result.replaceAll("\n\\ {4}", "\n");
        if (!codeblock.contains("\"java\"")) {
            result = ((Object)Strings.escapeMarkup((CharSequence)result)).toString();
        }
        return codeblock.substring(0, start) + result + "</pre>";
    }

    private static String handleAlert(String block) {
        int openTagStart = 0;
        int openTagEnd = block.indexOf("%}") + 2;
        int closeTagStart = block.indexOf("{%", openTagEnd);
        int closeTagEnd = block.indexOf("%}", closeTagStart) + 2;
        String tag = block.substring(openTagStart + 2, openTagEnd - 2).trim();
        Iterable tagParts = Splitter.on((String)"\\s+").split((CharSequence)tag);
        Iterator partIterator = tagParts.iterator();
        ArrayList<String> arguments = new ArrayList<String>();
        String tagname = (String)partIterator.next();
        for (String tagPart : tagParts) {
            arguments.add(tagPart);
        }
        String alertBody = block.substring(openTagEnd, closeTagStart);
        return "<div class=\"alert alert-info\">" + alertBody + "</div>";
    }
}

