/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.components;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.examples.base.AbstractBasePage;
import org.apache.wicket.examples.base.MarkdownArticleModel;
import org.apache.wicket.examples.base.annot.ExamplePage;
import org.apache.wicket.examples.base.components.AnchorLink;
import org.apache.wicket.examples.base.markdown.MarkdownLabel;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;

@ExamplePage(title="Component reference")
public class ComponentExamplesPage
extends AbstractBasePage {
    private static final long serialVersionUID = 1L;
    private RepeatingView articles = new RepeatingView("articles");
    private RepeatingView menuitems = new RepeatingView("menuitems");

    public ComponentExamplesPage() {
        this.getBody().add(new Behavior[]{AttributeModifier.replace((String)"data-spy", (Serializable)((Object)"scroll"))});
        this.getBody().add(new Behavior[]{AttributeModifier.replace((String)"data-target", (Serializable)((Object)".aw-docs-sidebar"))});
        this.add(new Component[]{this.articles});
        this.add(new Component[]{this.menuitems});
        this.addArticle("Labels.md");
        this.addArticle("Links.md");
        this.addArticle("Lists.md");
        this.addArticle("Pagination.md");
        this.addArticle("Forms.md");
        this.addArticle("Feedback.md");
        this.addArticle("Internationalization.md");
        this.addArticle("Layout.md");
    }

    private void addArticle(String article) {
        String title = article.substring(0, article.length() - 3);
        MarkdownLabel markdownLabel = new MarkdownLabel(this.articles.newChildId(), (IModel<?>)new MarkdownArticleModel(ComponentExamplesPage.class, article));
        this.articles.add(new Component[]{markdownLabel});
        markdownLabel.setMarkupId(title);
        markdownLabel.setOutputMarkupId(true);
        WebMarkupContainer menuitem = new WebMarkupContainer(this.menuitems.newChildId());
        this.menuitems.add(new Component[]{menuitem});
        menuitem.add(new Component[]{new AnchorLink("menuitem", title, title)});
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
    }
}

