/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.base;

import org.apache.wicket.Component;
import org.apache.wicket.bootstrap.Bootstrap;
import org.apache.wicket.examples.base.HomePage;
import org.apache.wicket.examples.base.annot.ExamplePage;
import org.apache.wicket.examples.base.navbar.TopNavbar;
import org.apache.wicket.examples.base.prettify.Prettify;
import org.apache.wicket.examples.basic.BasicExamplesPage;
import org.apache.wicket.examples.components.ComponentExamplesPage;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class AbstractBasePage
extends WebPage {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer body;

    public AbstractBasePage() {
        Component[] componentArray = new Component[1];
        this.body = new TransparentWebMarkupContainer("body");
        componentArray[0] = this.body;
        this.add(componentArray);
    }

    protected WebMarkupContainer getBody() {
        return this.body;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("title", (IModel)PropertyModel.of((Object)((Object)this), (String)"title")).setEscapeModelStrings(false)});
    }

    protected void onConfigure() {
        if (!this.hasBeenRendered()) {
            TopNavbar mainmenu = new TopNavbar("topnavbar");
            mainmenu.addMenuItem("Home", HomePage.class);
            mainmenu.addMenuItem("Basic", BasicExamplesPage.class);
            mainmenu.addMenuItem("Components", ComponentExamplesPage.class);
            this.add(new Component[]{mainmenu});
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        Bootstrap.renderHeadResponsive((IHeaderResponse)response);
        Prettify.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(AbstractBasePage.class, "docs.css")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(AbstractBasePage.class, "examples.js")));
    }

    public String getTitle() {
        ExamplePage examplePage = ((Object)((Object)this)).getClass().getAnnotation(ExamplePage.class);
        if (examplePage != null) {
            return examplePage.title() + " &mdash; Apache Wicket Examples";
        }
        return "Apache Wicket Examples";
    }
}

