/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tabs;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;

public class TabbedPanel<T extends ITab>
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String TAB_PANEL_ID = "panel";
    private final List<T> tabs;
    private int currentTab = -1;
    private transient VisibilityCache visibilityCache;

    public TabbedPanel(String id, List<T> tabs) {
        this(id, tabs, null);
    }

    public TabbedPanel(String id, List<T> tabs, IModel<Integer> model) {
        super(id, model);
        this.tabs = (List)Args.notNull(tabs, (String)"tabs");
        AbstractReadOnlyModel<Integer> tabCount = new AbstractReadOnlyModel<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                return TabbedPanel.this.tabs.size();
            }
        };
        WebMarkupContainer tabsContainer = this.newTabsContainer("tabs-container");
        this.add(new Component[]{tabsContainer});
        tabsContainer.add(new Component[]{new Loop("tabs", (IModel)tabCount){
            private static final long serialVersionUID = 1L;

            protected void populateItem(LoopItem item) {
                int index = item.getIndex();
                ITab tab = (ITab)TabbedPanel.this.tabs.get(index);
                WebMarkupContainer titleLink = TabbedPanel.this.newLink("link", index);
                titleLink.add(new Component[]{TabbedPanel.this.newTitle("title", tab.getTitle(), index)});
                item.add(new Component[]{titleLink});
            }

            protected LoopItem newItem(int iteration) {
                return TabbedPanel.this.newTabContainer(iteration);
            }
        }});
        this.add(new Component[]{this.newPanel()});
    }

    protected IModel<?> initModel() {
        return new Model((Serializable)Integer.valueOf(-1));
    }

    protected WebMarkupContainer newTabsContainer(String id) {
        return new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("class", (CharSequence)TabbedPanel.this.getTabContainerCssClass());
            }
        };
    }

    protected LoopItem newTabContainer(final int tabIndex) {
        return new LoopItem(tabIndex){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(TabbedPanel.this.getVisiblityCache().isVisible(tabIndex));
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String cssClass = tag.getAttribute("class");
                if (cssClass == null) {
                    cssClass = " ";
                }
                cssClass = cssClass + " tab" + this.getIndex();
                if (this.getIndex() == TabbedPanel.this.getSelectedTab()) {
                    cssClass = cssClass + ' ' + TabbedPanel.this.getSelectedTabCssClass();
                }
                if (TabbedPanel.this.getVisiblityCache().getLastVisible() == this.getIndex()) {
                    cssClass = cssClass + ' ' + TabbedPanel.this.getLastTabCssClass();
                }
                tag.put("class", (CharSequence)cssClass.trim());
            }
        };
    }

    protected void onBeforeRender() {
        int index = this.getSelectedTab();
        if (index == -1 || !this.getVisiblityCache().isVisible(index)) {
            index = -1;
            for (int i = 0; i < this.tabs.size(); ++i) {
                if (!this.getVisiblityCache().isVisible(i)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.setSelectedTab(index);
            }
        }
        this.setCurrentTab(index);
        super.onBeforeRender();
    }

    protected String getTabContainerCssClass() {
        return "tab-row";
    }

    protected String getLastTabCssClass() {
        return "last";
    }

    protected String getSelectedTabCssClass() {
        return "selected";
    }

    public final List<T> getTabs() {
        return this.tabs;
    }

    protected Component newTitle(String titleId, IModel<?> titleModel, int index) {
        return new Label(titleId, titleModel);
    }

    protected WebMarkupContainer newLink(String linkId, final int index) {
        return new Link<Void>(linkId){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                TabbedPanel.this.setSelectedTab(index);
            }
        };
    }

    public TabbedPanel<T> setSelectedTab(int index) {
        if (index < 0 || index >= this.tabs.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.setDefaultModelObject(index);
        this.currentTab = -1;
        this.setCurrentTab(index);
        return this;
    }

    private void setCurrentTab(int index) {
        WebMarkupContainer component;
        if (this.currentTab == index) {
            return;
        }
        this.currentTab = index;
        if (this.currentTab == -1 || this.tabs.size() == 0 || !this.getVisiblityCache().isVisible(this.currentTab)) {
            component = this.newPanel();
        } else {
            ITab tab = (ITab)this.tabs.get(this.currentTab);
            component = tab.getPanel(TAB_PANEL_ID);
            if (component == null) {
                throw new WicketRuntimeException("ITab.getPanel() returned null. TabbedPanel [" + this.getPath() + "] ITab index [" + this.currentTab + "]");
            }
        }
        if (!component.getId().equals(TAB_PANEL_ID)) {
            throw new WicketRuntimeException("ITab.getPanel() returned a panel with invalid id [" + component.getId() + "]. You must always return a panel with id equal to the provided panelId parameter. TabbedPanel [" + this.getPath() + "] ITab index [" + this.currentTab + "]");
        }
        this.addOrReplace(new Component[]{component});
    }

    private WebMarkupContainer newPanel() {
        return new WebMarkupContainer(TAB_PANEL_ID);
    }

    public final int getSelectedTab() {
        return (Integer)this.getDefaultModelObject();
    }

    protected void onDetach() {
        this.visibilityCache = null;
        super.onDetach();
    }

    private VisibilityCache getVisiblityCache() {
        if (this.visibilityCache == null) {
            this.visibilityCache = new VisibilityCache();
        }
        return this.visibilityCache;
    }

    private class VisibilityCache {
        private Boolean[] visibilities;
        private int lastVisible = -1;

        public VisibilityCache() {
            this.visibilities = new Boolean[TabbedPanel.this.tabs.size()];
        }

        public int getLastVisible() {
            if (this.lastVisible == -1) {
                for (int t = 0; t < TabbedPanel.this.tabs.size(); ++t) {
                    if (!this.isVisible(t)) continue;
                    this.lastVisible = t;
                }
            }
            return this.lastVisible;
        }

        public boolean isVisible(int index) {
            if (this.visibilities.length < index + 1) {
                Boolean[] resized = new Boolean[index + 1];
                System.arraycopy(this.visibilities, 0, resized, 0, this.visibilities.length);
                this.visibilities = resized;
            }
            if (this.visibilities.length > 0) {
                Boolean visible = this.visibilities[index];
                if (visible == null) {
                    this.visibilities[index] = visible = Boolean.valueOf(((ITab)TabbedPanel.this.tabs.get(index)).isVisible());
                }
                return visible;
            }
            return false;
        }
    }
}

