/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.parameter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.StringList;
import org.apache.wicket.util.string.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> indexedParameters;
    private List<Entry> namedParameters;

    public PageParameters() {
    }

    public PageParameters(PageParameters copy) {
        if (copy != null) {
            if (copy.indexedParameters != null) {
                this.indexedParameters = new ArrayList<String>(copy.indexedParameters);
            }
            if (copy.namedParameters != null) {
                this.namedParameters = new ArrayList<Entry>(copy.namedParameters);
            }
        }
    }

    @Deprecated
    public PageParameters(String keyValuePairs) {
        this(keyValuePairs, ",");
    }

    @Deprecated
    public PageParameters(String keyValuePairs, String delimiter) {
        StringList pairs = StringList.tokenize((String)keyValuePairs, (String)delimiter);
        for (String pair : pairs) {
            String value;
            String key;
            int pos = pair.indexOf(61);
            if (pos == 0) {
                throw new IllegalArgumentException("URL parameter is missing the lvalue: " + pair);
            }
            if (pos != -1) {
                key = pair.substring(0, pos).trim();
                value = pair.substring(pos + 1).trim();
                this.addNamedParameter(key, value);
                continue;
            }
            key = pair.trim();
            value = null;
            this.addNamedParameter(key, value);
        }
    }

    public int getIndexedParamsCount() {
        return this.indexedParameters != null ? this.indexedParameters.size() : 0;
    }

    public void setIndexedParameter(int index, Object object) {
        if (this.indexedParameters == null) {
            this.indexedParameters = new ArrayList<String>(index);
        }
        for (int i = this.indexedParameters.size(); i <= index; ++i) {
            this.indexedParameters.add(null);
        }
        this.indexedParameters.set(index, object != null ? object.toString() : null);
    }

    public StringValue getIndexedParameter(int index) {
        if (this.indexedParameters != null && index >= 0 && index < this.indexedParameters.size()) {
            return StringValue.valueOf((String)this.indexedParameters.get(index));
        }
        return StringValue.valueOf((String)null);
    }

    public void removeIndexedParameter(int index) {
        if (this.indexedParameters != null && index >= 0 && index < this.indexedParameters.size()) {
            this.indexedParameters.remove(index);
        }
    }

    public Set<String> getNamedParameterKeys() {
        if (this.namedParameters == null || this.namedParameters.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<String> set = new TreeSet<String>();
        for (Entry entry : this.namedParameters) {
            set.add(entry.key);
        }
        return Collections.unmodifiableSet(set);
    }

    public StringValue getNamedParameter(String name) {
        Checks.argumentNotNull((Object)name, (String)"name");
        if (this.namedParameters != null) {
            for (Entry entry : this.namedParameters) {
                if (!entry.key.equals(name)) continue;
                return StringValue.valueOf((String)entry.value);
            }
        }
        return StringValue.valueOf((String)null);
    }

    public List<StringValue> getNamedParameters(String name) {
        Checks.argumentNotNull((Object)name, (String)"name");
        if (this.namedParameters != null) {
            ArrayList<StringValue> result = new ArrayList<StringValue>();
            for (Entry entry : this.namedParameters) {
                if (!entry.key.equals(name)) continue;
                result.add(StringValue.valueOf((String)entry.value));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    public List<NamedParameterPair> getNamedParameters() {
        ArrayList<NamedParameterPair> res = new ArrayList<NamedParameterPair>();
        if (this.namedParameters != null) {
            for (Entry e : this.namedParameters) {
                res.add(new NamedParameterPair(e.key, e.value));
            }
        }
        return Collections.unmodifiableList(res);
    }

    public void removeNamedParameter(String name) {
        Checks.argumentNotNull((Object)name, (String)"name");
        if (this.namedParameters != null) {
            Iterator<Entry> i = this.namedParameters.iterator();
            while (i.hasNext()) {
                Entry e = i.next();
                if (!e.key.equals(name)) continue;
                i.remove();
            }
        }
    }

    public void addNamedParameter(String name, Object value) {
        this.addNamedParameter(name, value, -1);
    }

    public void addNamedParameter(String name, Object value, int index) {
        Checks.argumentNotNull((Object)name, (String)"name");
        Checks.argumentNotNull((Object)value, (String)"value");
        if (this.namedParameters == null) {
            this.namedParameters = new ArrayList<Entry>(1);
        }
        Entry entry = new Entry();
        entry.key = name;
        entry.value = value.toString();
        if (index == -1) {
            this.namedParameters.add(entry);
        } else {
            this.namedParameters.add(index, entry);
        }
    }

    public void setNamedParameter(String name, Object value, int index) {
        this.removeNamedParameter(name);
        if (value != null) {
            this.addNamedParameter(name, value);
        }
    }

    public void setNamedParameter(String name, Object value) {
        this.setNamedParameter(name, value, -1);
    }

    public void clearIndexedParameters() {
        this.indexedParameters = null;
    }

    public void clearNamedParameters() {
        this.namedParameters = null;
    }

    public void assign(PageParameters other) {
        if (this != other) {
            this.indexedParameters = other.indexedParameters;
            this.namedParameters = other.namedParameters;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageParameters)) {
            return false;
        }
        PageParameters rhs = (PageParameters)obj;
        if (!Objects.equal(this.indexedParameters, rhs.indexedParameters)) {
            return false;
        }
        if (this.namedParameters == null || rhs.namedParameters == null) {
            return rhs.namedParameters == this.namedParameters;
        }
        if (this.namedParameters.size() != rhs.namedParameters.size()) {
            return false;
        }
        for (String key : this.getNamedParameterKeys()) {
            List<StringValue> values1 = this.getNamedParameters(key);
            TreeSet<String> v1 = new TreeSet<String>();
            List<StringValue> values2 = rhs.getNamedParameters(key);
            TreeSet<String> v2 = new TreeSet<String>();
            for (StringValue sv : values1) {
                v1.add(sv.toString());
            }
            for (StringValue sv : values2) {
                v2.add(sv.toString());
            }
            if (((Object)v1).equals(v2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(PageParameters p1, PageParameters p2) {
        if (Objects.equal((Object)p1, (Object)p2)) {
            return true;
        }
        if (p1 == null && p2.getIndexedParamsCount() == 0 && p2.getNamedParameterKeys().isEmpty()) {
            return true;
        }
        return p2 == null && p1.getIndexedParamsCount() == 0 && p1.getNamedParameterKeys().isEmpty();
    }

    public boolean isEmpty() {
        return this.getIndexedParamsCount() == 0 && this.getNamedParameterKeys().isEmpty();
    }

    public static class NamedParameterPair {
        private final String key;
        private final String value;

        private NamedParameterPair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String key;
        private String value;

        private Entry() {
        }
    }
}

