/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.parameter;

import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class PageParametersEncoder
implements IPageParametersEncoder {
    public PageParameters decodePageParameters(Request request) {
        PageParameters parameters = new PageParameters();
        int i = 0;
        for (String s : request.getUrl().getSegments()) {
            parameters.setIndexedParameter(i, s);
            ++i;
        }
        for (Url.QueryParameter p : request.getUrl().getQueryParameters()) {
            parameters.addNamedParameter(p.getName(), p.getValue());
        }
        return parameters.isEmpty() ? null : parameters;
    }

    public Url encodePageParameters(PageParameters pageParameters) {
        Url url = new Url();
        for (int i = 0; i < pageParameters.getIndexedParamsCount(); ++i) {
            url.getSegments().add(pageParameters.getIndexedParameter(i).toString());
        }
        for (PageParameters.NamedParameterPair pair : pageParameters.getNamedParameters()) {
            Url.QueryParameter param = new Url.QueryParameter(pair.getKey(), pair.getValue());
            url.getQueryParameters().add(param);
        }
        return url;
    }
}

