/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.PrependingStringBuffer;

public class UrlRenderer {
    private Url baseUrl;

    public UrlRenderer(Url base) {
        Args.notNull((Object)base, (String)"base");
        this.baseUrl = base;
    }

    public Url setBaseUrl(Url base) {
        Args.notNull((Object)base, (String)"base");
        Url original = this.baseUrl;
        this.baseUrl = base;
        return original;
    }

    public Url getBaseUrl() {
        return this.baseUrl;
    }

    public String renderUrl(Url url) {
        Args.notNull((Object)url, (String)"url");
        if (url.isAbsolute()) {
            return url.toString();
        }
        List<String> baseUrlSegments = this.getBaseUrl().getSegments();
        ArrayList<String> urlSegments = new ArrayList<String>(url.getSegments());
        ArrayList<String> newSegments = new ArrayList<String>();
        int common = 0;
        String last = null;
        for (String s : baseUrlSegments) {
            if (urlSegments.isEmpty() || !s.equals(urlSegments.get(0))) break;
            ++common;
            last = (String)urlSegments.remove(0);
        }
        if (last != null && (urlSegments.isEmpty() || baseUrlSegments.size() == common)) {
            --common;
            urlSegments.add(0, last);
        }
        for (int i = common + 1; i < baseUrlSegments.size(); ++i) {
            newSegments.add("..");
        }
        newSegments.addAll(urlSegments);
        return new Url(newSegments, url.getQueryParameters()).toString();
    }

    public String renderContextPathRelativeUrl(String url, Request request) {
        Args.notNull((Object)url, (String)"url");
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        PrependingStringBuffer buffer = new PrependingStringBuffer(url);
        for (int i = 0; i < this.baseUrl.getSegments().size() - 1; ++i) {
            buffer.prepend("../");
        }
        buffer.prepend(request.getPrefixToContextPath());
        return buffer.toString();
    }
}

