/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.parameter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.StringList;
import org.apache.wicket.util.string.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> indexedParameters;
    private List<Entry> namedParameters;

    public PageParameters() {
    }

    public PageParameters(PageParameters copy) {
        if (copy != null) {
            if (copy.indexedParameters != null) {
                this.indexedParameters = new ArrayList<String>(copy.indexedParameters);
            }
            if (copy.namedParameters != null) {
                this.namedParameters = new ArrayList<Entry>(copy.namedParameters);
            }
        }
    }

    @Deprecated
    public PageParameters(String keyValuePairs) {
        this(keyValuePairs, ",");
    }

    @Deprecated
    public PageParameters(String keyValuePairs, String delimiter) {
        StringList pairs = StringList.tokenize((String)keyValuePairs, (String)delimiter);
        for (String pair : pairs) {
            String value;
            String key;
            int pos = pair.indexOf(61);
            if (pos == 0) {
                throw new IllegalArgumentException("URL parameter is missing the lvalue: " + pair);
            }
            if (pos != -1) {
                key = pair.substring(0, pos).trim();
                value = pair.substring(pos + 1).trim();
                this.add(key, value);
                continue;
            }
            key = pair.trim();
            value = null;
            this.add(key, value);
        }
    }

    public int getIndexedCount() {
        return this.indexedParameters != null ? this.indexedParameters.size() : 0;
    }

    public PageParameters set(int index, Object object) {
        if (this.indexedParameters == null) {
            this.indexedParameters = new ArrayList<String>(index);
        }
        for (int i = this.indexedParameters.size(); i <= index; ++i) {
            this.indexedParameters.add(null);
        }
        this.indexedParameters.set(index, object != null ? object.toString() : null);
        return this;
    }

    public StringValue get(int index) {
        if (this.indexedParameters != null && index >= 0 && index < this.indexedParameters.size()) {
            return StringValue.valueOf((String)this.indexedParameters.get(index));
        }
        return StringValue.valueOf((String)null);
    }

    public PageParameters remove(int index) {
        if (this.indexedParameters != null && index >= 0 && index < this.indexedParameters.size()) {
            this.indexedParameters.remove(index);
        }
        return this;
    }

    public Set<String> getNamedKeys() {
        if (this.namedParameters == null || this.namedParameters.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<String> set = new TreeSet<String>();
        for (Entry entry : this.namedParameters) {
            set.add(entry.key);
        }
        return Collections.unmodifiableSet(set);
    }

    public StringValue get(String name) {
        Args.notNull((Object)name, (String)"name");
        if (this.namedParameters != null) {
            for (Entry entry : this.namedParameters) {
                if (!entry.key.equals(name)) continue;
                return StringValue.valueOf((String)entry.value);
            }
        }
        return StringValue.valueOf((String)null);
    }

    public List<StringValue> getValues(String name) {
        Args.notNull((Object)name, (String)"name");
        if (this.namedParameters != null) {
            ArrayList<StringValue> result = new ArrayList<StringValue>();
            for (Entry entry : this.namedParameters) {
                if (!entry.key.equals(name)) continue;
                result.add(StringValue.valueOf((String)entry.value));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    public List<NamedPair> getAllNamed() {
        ArrayList<NamedPair> res = new ArrayList<NamedPair>();
        if (this.namedParameters != null) {
            for (Entry e : this.namedParameters) {
                res.add(new NamedPair(e.key, e.value));
            }
        }
        return Collections.unmodifiableList(res);
    }

    public PageParameters remove(String name) {
        Args.notNull((Object)name, (String)"name");
        if (this.namedParameters != null) {
            Iterator<Entry> i = this.namedParameters.iterator();
            while (i.hasNext()) {
                Entry e = i.next();
                if (!e.key.equals(name)) continue;
                i.remove();
            }
        }
        return this;
    }

    public PageParameters add(String name, Object value) {
        this.add(name, value, -1);
        return this;
    }

    public PageParameters add(String name, Object value, int index) {
        Args.notNull((Object)name, (String)"name");
        Args.notNull((Object)value, (String)"value");
        if (this.namedParameters == null) {
            this.namedParameters = new ArrayList<Entry>(1);
        }
        Entry entry = new Entry();
        entry.key = name;
        entry.value = value.toString();
        if (index == -1) {
            this.namedParameters.add(entry);
        } else {
            this.namedParameters.add(index, entry);
        }
        return this;
    }

    public PageParameters set(String name, Object value, int index) {
        this.remove(name);
        if (value != null) {
            this.add(name, value);
        }
        return this;
    }

    public PageParameters set(String name, Object value) {
        this.set(name, value, -1);
        return this;
    }

    public PageParameters clearIndexed() {
        this.indexedParameters = null;
        return this;
    }

    public PageParameters clearaNamed() {
        this.namedParameters = null;
        return this;
    }

    public PageParameters overwriteWith(PageParameters other) {
        if (this != other) {
            this.indexedParameters = other.indexedParameters;
            this.namedParameters = other.namedParameters;
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageParameters)) {
            return false;
        }
        PageParameters rhs = (PageParameters)obj;
        if (!Objects.equal(this.indexedParameters, rhs.indexedParameters)) {
            return false;
        }
        if (this.namedParameters == null || rhs.namedParameters == null) {
            return rhs.namedParameters == this.namedParameters;
        }
        if (this.namedParameters.size() != rhs.namedParameters.size()) {
            return false;
        }
        for (String key : this.getNamedKeys()) {
            List<StringValue> values1 = this.getValues(key);
            TreeSet<String> v1 = new TreeSet<String>();
            List<StringValue> values2 = rhs.getValues(key);
            TreeSet<String> v2 = new TreeSet<String>();
            for (StringValue sv : values1) {
                v1.add(sv.toString());
            }
            for (StringValue sv : values2) {
                v2.add(sv.toString());
            }
            if (((Object)v1).equals(v2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(PageParameters p1, PageParameters p2) {
        if (Objects.equal((Object)p1, (Object)p2)) {
            return true;
        }
        if (p1 == null && p2.getIndexedCount() == 0 && p2.getNamedKeys().isEmpty()) {
            return true;
        }
        return p2 == null && p1.getIndexedCount() == 0 && p1.getNamedKeys().isEmpty();
    }

    public boolean isEmpty() {
        return this.getIndexedCount() == 0 && this.getNamedKeys().isEmpty();
    }

    public static class NamedPair {
        private final String key;
        private final String value;

        private NamedPair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String key;
        private String value;

        private Entry() {
        }
    }
}

