/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.parameter;

import java.util.List;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class PageParametersTest
extends Assert {
    @Test
    public void addStringArrayValue() {
        PageParameters parameters = new PageParameters();
        String[] input = new String[]{"v1", "v2"};
        parameters.add("key", (Object)input);
        List stringValue = parameters.getValues("key");
        for (String in : input) {
            boolean found = false;
            for (StringValue value : stringValue) {
                if (!value.toString().equals(in)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalStateException("Expected to find a StringValue with value: " + in);
        }
    }

    @Test
    public void getPosition() {
        PageParameters parameters = new PageParameters();
        parameters.set("named1", (Object)"value1", 3);
        PageParametersTest.assertEquals((String)"Adding a parameter at position out of the size of the list will just append it", (long)0L, (long)parameters.getPosition("named1"));
        parameters.set("named2", (Object)"value2", 0);
        PageParametersTest.assertEquals((long)0L, (long)parameters.getPosition("named2"));
        PageParametersTest.assertEquals((String)"'named1' should be moved back", (long)1L, (long)parameters.getPosition("named1"));
        parameters.set("named3", (Object)"value3", -100);
        PageParametersTest.assertEquals((long)0L, (long)parameters.getPosition("named2"));
        PageParametersTest.assertEquals((long)1L, (long)parameters.getPosition("named1"));
        PageParametersTest.assertEquals((String)"Adding a parameter with negative position will just append it.", (long)2L, (long)parameters.getPosition("named3"));
    }

    @Test
    public void set() {
        PageParameters parameters = new PageParameters();
        parameters.add("named1", (Object)"value1").add("named2", (Object)"value2");
        PageParametersTest.assertEquals((long)0L, (long)parameters.getPosition("named1"));
        PageParametersTest.assertEquals((long)1L, (long)parameters.getPosition("named2"));
        parameters.set("named1", (Object)"newValue");
        parameters.set("named3", (Object)"value3");
        PageParametersTest.assertEquals((long)0L, (long)parameters.getPosition("named1"));
        PageParametersTest.assertEquals((Object)"newValue", (Object)parameters.get("named1").toString());
        PageParametersTest.assertEquals((long)1L, (long)parameters.getPosition("named2"));
        PageParametersTest.assertEquals((long)2L, (long)parameters.getPosition("named3"));
    }
}

