/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.parameter.CombinedRequestParametersAdapter;
import org.apache.wicket.request.parameter.EmptyRequestParameters;
import org.apache.wicket.request.parameter.UrlRequestParametersAdapter;

public abstract class Request {
    public abstract Url getUrl();

    public abstract Url getClientUrl();

    public Url getOriginalUrl() {
        return this.getUrl();
    }

    public IRequestParameters getPostParameters() {
        return EmptyRequestParameters.INSTANCE;
    }

    public IRequestParameters getQueryParameters() {
        return new UrlRequestParametersAdapter(this.getUrl());
    }

    public IRequestParameters getRequestParameters() {
        return new CombinedRequestParametersAdapter(this.getQueryParameters(), this.getPostParameters());
    }

    public abstract Locale getLocale();

    public Request cloneWithUrl(final Url url) {
        return new Request(){

            public Url getUrl() {
                return url;
            }

            public Url getOriginalUrl() {
                return Request.this.getOriginalUrl();
            }

            public Locale getLocale() {
                return Request.this.getLocale();
            }

            public IRequestParameters getPostParameters() {
                return Request.this.getPostParameters();
            }

            public Charset getCharset() {
                return Request.this.getCharset();
            }

            public Url getClientUrl() {
                return this.getUrl();
            }

            public Object getContainerRequest() {
                return Request.this.getContainerRequest();
            }
        };
    }

    public String getPrefixToContextPath() {
        return "";
    }

    public abstract Charset getCharset();

    public abstract Object getContainerRequest();
}

