/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.info;

import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class ComponentInfo {
    private static final char BEHAVIOR_INDEX_SEPARATOR = '.';
    private static final char SEPARATOR = '-';
    private static final char COMPONENT_SEPARATOR = ':';
    private final String listenerInterface;
    private final String componentPath;
    private final Integer behaviorId;
    private final Integer renderCount;

    private static String encodeComponentPath(CharSequence path) {
        if (path != null) {
            StringBuilder result = new StringBuilder();
            int length = path.length();
            block4: for (int i = 0; i < length; ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case ':': {
                        result.append('-');
                        continue block4;
                    }
                    case '-': {
                        result.append('-').append('-');
                        continue block4;
                    }
                    default: {
                        result.append(c);
                    }
                }
            }
            return result.toString();
        }
        return null;
    }

    private static String decodeComponentPath(CharSequence path) {
        if (path != null) {
            StringBuilder result = new StringBuilder();
            int length = path.length();
            block3: for (int i = 0; i < length; ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case '-': {
                        if (i < length - 1 && path.charAt(i + 1) == '-') {
                            ++i;
                            result.append('-');
                            continue block3;
                        }
                        result.append(':');
                        continue block3;
                    }
                    default: {
                        result.append(c);
                    }
                }
            }
            return result.toString();
        }
        return null;
    }

    public ComponentInfo(Integer renderCount, String listenerInterface, String componentPath, Integer behaviorId) {
        Args.notEmpty((CharSequence)listenerInterface, (String)"listenerInterface");
        Args.notNull((Object)componentPath, (String)"componentPath");
        this.listenerInterface = listenerInterface;
        this.componentPath = componentPath;
        this.behaviorId = behaviorId;
        this.renderCount = renderCount;
    }

    public String getComponentPath() {
        return this.componentPath;
    }

    public String getListenerInterface() {
        return this.listenerInterface;
    }

    public Integer getBehaviorId() {
        return this.behaviorId;
    }

    public Integer getRenderCount() {
        return this.renderCount;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.renderCount != null) {
            result.append(this.renderCount);
            result.append('.');
        }
        result.append(this.listenerInterface);
        if (this.behaviorId != null) {
            result.append('.');
            result.append(this.behaviorId);
        }
        result.append('-');
        result.append(ComponentInfo.encodeComponentPath(this.componentPath));
        return result.toString();
    }

    private static boolean isNumber(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ComponentInfo parse(String string) {
        if (Strings.isEmpty((CharSequence)string)) {
            return null;
        }
        int i = string.indexOf(45);
        if (i == -1) {
            return null;
        }
        String listenerInterface = string.substring(0, i);
        String componentPath = ComponentInfo.decodeComponentPath(string.substring(i + 1));
        if (Strings.isEmpty((CharSequence)listenerInterface)) {
            return null;
        }
        Integer behaviorIndex = null;
        Integer renderCount = null;
        String[] listenerParts = Strings.split((String)listenerInterface, (char)'.');
        if (listenerParts.length == 2) {
            if (ComponentInfo.isNumber(listenerParts[0])) {
                renderCount = Integer.valueOf(listenerParts[0]);
                listenerInterface = listenerParts[1];
                return new ComponentInfo(renderCount, listenerInterface, componentPath, behaviorIndex);
            } else {
                if (!ComponentInfo.isNumber(listenerParts[1])) return null;
                listenerInterface = listenerParts[0];
                behaviorIndex = Integer.valueOf(listenerParts[1]);
            }
            return new ComponentInfo(renderCount, listenerInterface, componentPath, behaviorIndex);
        } else if (listenerParts.length == 3) {
            if (!ComponentInfo.isNumber(listenerParts[0]) && !ComponentInfo.isNumber(listenerParts[1])) {
                return null;
            }
            renderCount = Integer.valueOf(listenerParts[0]);
            listenerInterface = listenerParts[1];
            behaviorIndex = Integer.valueOf(listenerParts[2]);
            return new ComponentInfo(renderCount, listenerInterface, componentPath, behaviorIndex);
        } else {
            if (listenerParts.length == 1) return new ComponentInfo(renderCount, listenerInterface, componentPath, behaviorIndex);
            return null;
        }
    }
}

