/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.parameter;

import java.util.Iterator;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class UrlPathPageParametersEncoder
implements IPageParametersEncoder {
    public Url encodePageParameters(PageParameters params) {
        Args.notNull((Object)params, (String)"params");
        Args.isTrue((params.getIndexedCount() == 0 ? 1 : 0) != 0, (String)"This encoder does not support indexed page parameters. Specified parameters: %s", (Object[])new Object[]{params});
        Url url = new Url();
        for (PageParameters.NamedPair pair : params.getAllNamed()) {
            url.getSegments().add(pair.getKey());
            url.getSegments().add(pair.getValue());
        }
        return url;
    }

    public PageParameters decodePageParameters(Request request) {
        PageParameters params = new PageParameters();
        Iterator<String> segment = request.getUrl().getSegments().iterator();
        while (segment.hasNext()) {
            String key = segment.next();
            if (Strings.isEmpty((CharSequence)key) || !segment.hasNext()) continue;
            String value = segment.next();
            params.add(key, value);
        }
        return params.isEmpty() ? null : params;
    }
}

