/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.mount;

import org.apache.wicket.request.mapper.mount.MountParameters;
import org.apache.wicket.util.string.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class MountParametersTest {
    @Test
    public void getNonExistingPlaceholder() {
        MountParameters placeholders = new MountParameters();
        StringValue value = placeholders.getValue("non-existing");
        Assert.assertTrue((boolean)value.isNull());
    }

    @Test
    public void getExistingPlaceholder() {
        String parameterName = "placeholder";
        StringValue originalValue = StringValue.valueOf((String)"value");
        MountParameters placeholders = new MountParameters();
        placeholders.setValue("placeholder", originalValue);
        StringValue actualValue = placeholders.getValue("placeholder");
        Assert.assertEquals((Object)originalValue.toString(), (Object)actualValue.toString());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void cannotModifyByNamesSet() {
        MountParameters placeholders = new MountParameters();
        placeholders.setValue("some", StringValue.valueOf((String)"value"));
        placeholders.getParameterNames().iterator().remove();
    }
}

