/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.parameter;

import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.UrlPathPageParametersEncoder;
import org.junit.Assert;
import org.junit.Test;

public class UrlPathPageParametersEncoderTest
extends Assert {
    @Test
    public void encodeNamedParameters() {
        PageParameters params = new PageParameters();
        params.add("name1", (Object)"value1");
        params.add("name2", (Object)"value2");
        UrlPathPageParametersEncoder encoder = new UrlPathPageParametersEncoder();
        Url url = encoder.encodePageParameters(params);
        UrlPathPageParametersEncoderTest.assertEquals((Object)"name1/value1/name2/value2", (Object)url.toString());
    }

    @Test
    public void encodeNamedParametersWithSpecialChars() {
        PageParameters params = new PageParameters();
        params.add("name1", (Object)"value\u098f");
        params.add("name\u3118", (Object)"value2");
        UrlPathPageParametersEncoder encoder = new UrlPathPageParametersEncoder();
        Url url = encoder.encodePageParameters(params);
        UrlPathPageParametersEncoderTest.assertEquals((Object)"name1/value%E0%A6%8F/name%E3%84%98/value2", (Object)url.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void encodeIndexedParameters() {
        PageParameters params = new PageParameters();
        params.set(0, (Object)"value1");
        params.set(1, (Object)"value2");
        UrlPathPageParametersEncoder encoder = new UrlPathPageParametersEncoder();
        encoder.encodePageParameters(params);
    }

    @Test
    public void decodeUrl() {
        Url url = Url.parse((String)"name1/value1/name2/value2");
        Request request = this.getRequest(url);
        UrlPathPageParametersEncoder decoder = new UrlPathPageParametersEncoder();
        PageParameters parameters = decoder.decodePageParameters(request);
        UrlPathPageParametersEncoderTest.assertEquals((long)2L, (long)parameters.getAllNamed().size());
        UrlPathPageParametersEncoderTest.assertEquals((Object)"value1", (Object)parameters.get("name1").toString());
        UrlPathPageParametersEncoderTest.assertEquals((Object)"value2", (Object)parameters.get("name2").toString());
    }

    @Test
    public void decodeUrlWithTrailingSlash() {
        Url url = Url.parse((String)"name1/value1/name2/value2/");
        Request request = this.getRequest(url);
        UrlPathPageParametersEncoder decoder = new UrlPathPageParametersEncoder();
        PageParameters parameters = decoder.decodePageParameters(request);
        UrlPathPageParametersEncoderTest.assertEquals((long)2L, (long)parameters.getAllNamed().size());
        UrlPathPageParametersEncoderTest.assertEquals((Object)"value1", (Object)parameters.get("name1").toString());
        UrlPathPageParametersEncoderTest.assertEquals((Object)"value2", (Object)parameters.get("name2").toString());
    }

    @Test
    public void decodeUrlWithTrailingSlashAfterName() {
        Url url = Url.parse((String)"name1/value1/name2/value2/name3");
        Request request = this.getRequest(url);
        UrlPathPageParametersEncoder decoder = new UrlPathPageParametersEncoder();
        PageParameters parameters = decoder.decodePageParameters(request);
        UrlPathPageParametersEncoderTest.assertEquals((long)2L, (long)parameters.getAllNamed().size());
        UrlPathPageParametersEncoderTest.assertEquals((Object)"value1", (Object)parameters.get("name1").toString());
        UrlPathPageParametersEncoderTest.assertEquals((Object)"value2", (Object)parameters.get("name2").toString());
    }

    @Test
    public void decodeUrlWithLeadingSlash() {
        Url url = Url.parse((String)"/name1/value1/name2/value2");
        Request request = this.getRequest(url);
        UrlPathPageParametersEncoder decoder = new UrlPathPageParametersEncoder();
        PageParameters parameters = decoder.decodePageParameters(request);
        UrlPathPageParametersEncoderTest.assertEquals((long)2L, (long)parameters.getAllNamed().size());
        UrlPathPageParametersEncoderTest.assertEquals((Object)"value1", (Object)parameters.get("name1").toString());
        UrlPathPageParametersEncoderTest.assertEquals((Object)"value2", (Object)parameters.get("name2").toString());
    }

    @Test
    public void decodeUrlWithSlashesInTheMiddle() {
        Url url = Url.parse((String)"name1/value1////name2/value2");
        Request request = this.getRequest(url);
        UrlPathPageParametersEncoder decoder = new UrlPathPageParametersEncoder();
        PageParameters parameters = decoder.decodePageParameters(request);
        UrlPathPageParametersEncoderTest.assertEquals((long)2L, (long)parameters.getAllNamed().size());
        UrlPathPageParametersEncoderTest.assertEquals((Object)"value1", (Object)parameters.get("name1").toString());
        UrlPathPageParametersEncoderTest.assertEquals((Object)"value2", (Object)parameters.get("name2").toString());
    }

    @Test
    public void decodeUrlWithSlashesInTheMiddleAndEmptyValue() {
        Url url = Url.parse((String)"name1/value1////name2//");
        Request request = this.getRequest(url);
        UrlPathPageParametersEncoder decoder = new UrlPathPageParametersEncoder();
        PageParameters parameters = decoder.decodePageParameters(request);
        UrlPathPageParametersEncoderTest.assertEquals((long)2L, (long)parameters.getAllNamed().size());
        UrlPathPageParametersEncoderTest.assertEquals((Object)"value1", (Object)parameters.get("name1").toString());
        UrlPathPageParametersEncoderTest.assertEquals((Object)"", (Object)parameters.get("name2").toString());
    }

    private Request getRequest(final Url url) {
        return new Request(){

            public Url getUrl() {
                return url;
            }

            public Locale getLocale() {
                return null;
            }

            public Object getContainerRequest() {
                return null;
            }

            public Url getClientUrl() {
                return url;
            }

            public Charset getCharset() {
                return null;
            }
        };
    }
}

