/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.handler.EmptyRequestHandler;
import org.apache.wicket.request.mapper.CompoundRequestMapper;
import org.apache.wicket.request.mapper.mount.MountMapper;
import org.junit.Assert;
import org.junit.Test;

public class CompoundRequestMapperTest
extends Assert {
    private static final String MOUNT_PATH_3 = "mount/path/3";
    private static final String MOUNT_PATH_2 = "mount/path/2";
    private static final String MOUNT_PATH_1 = "mount/path/1";

    @Test
    public void unmount() {
        CompoundRequestMapper compound = new CompoundRequestMapper();
        compound.add((IRequestMapper)new MountMapper(MOUNT_PATH_1, (IRequestHandler)new EmptyRequestHandler()));
        compound.add((IRequestMapper)new MountMapper(MOUNT_PATH_2, (IRequestHandler)new EmptyRequestHandler()));
        compound.add((IRequestMapper)new MountMapper(MOUNT_PATH_3, (IRequestHandler)new EmptyRequestHandler()));
        CompoundRequestMapperTest.assertEquals((long)3L, (long)compound.size());
        compound.unmount(MOUNT_PATH_2);
        CompoundRequestMapperTest.assertEquals((long)2L, (long)compound.size());
        CompoundRequestMapperTest.assertTrue((String)"Mount path 1 should match", (boolean)(compound.mapRequest(compound.createRequest(Url.parse((String)MOUNT_PATH_1))) instanceof EmptyRequestHandler));
        CompoundRequestMapperTest.assertNull((String)"Mount path 2 should not match", (Object)compound.mapRequest(compound.createRequest(Url.parse((String)MOUNT_PATH_2))));
        CompoundRequestMapperTest.assertTrue((String)"Mount path 3 should match", (boolean)(compound.mapRequest(compound.createRequest(Url.parse((String)MOUNT_PATH_3))) instanceof EmptyRequestHandler));
    }
}

