/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.parameter;

import java.util.List;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;

public class PageParametersEncoder
implements IPageParametersEncoder {
    public PageParameters decodePageParameters(Request request) {
        PageParameters parameters = new PageParameters();
        int i = 0;
        for (String s : request.getUrl().getSegments()) {
            parameters.set(i, (Object)s);
            ++i;
        }
        IRequestParameters requestParameters = request.getRequestParameters();
        for (String paramName : requestParameters.getParameterNames()) {
            List<StringValue> parameterValues = requestParameters.getParameterValues(paramName);
            for (StringValue paramValue : parameterValues) {
                parameters.add(paramName, paramValue);
            }
        }
        return parameters.isEmpty() ? null : parameters;
    }

    public Url encodePageParameters(PageParameters pageParameters) {
        Url url = new Url();
        for (int i = 0; i < pageParameters.getIndexedCount(); ++i) {
            url.getSegments().add(pageParameters.get(i).toString());
        }
        for (PageParameters.NamedPair pair : pageParameters.getAllNamed()) {
            Url.QueryParameter param = new Url.QueryParameter(pair.getKey(), pair.getValue());
            url.getQueryParameters().add(param);
        }
        return url;
    }
}

