/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring.test;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.core.io.Resource;

public class ApplicationContextMock
implements ApplicationContext,
Serializable {
    private Map beans = new HashMap();

    public void putBean(String name, Object bean) {
        if (this.beans.containsKey(name)) {
            throw new IllegalArgumentException("a bean with name [" + name + "] has alredy been added to the context");
        }
        this.beans.put(name, bean);
    }

    public void putBean(Object bean) {
        this.putBean(bean.getClass().getName(), bean);
    }

    public Object getBean(String name) throws BeansException {
        throw new UnsupportedOperationException();
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        Object bean = this.beans.get(name);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(requiredType, name);
        }
        if (!requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean.getClass());
        }
        return bean;
    }

    public Map getBeansOfType(Class type) throws BeansException {
        HashMap found = new HashMap();
        Iterator it = this.beans.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!type.isAssignableFrom(entry.getValue().getClass())) continue;
            found.put(entry.getKey(), entry.getValue());
        }
        return found;
    }

    public ApplicationContext getParent() {
        throw new UnsupportedOperationException();
    }

    public String getDisplayName() {
        throw new UnsupportedOperationException();
    }

    public long getStartupDate() {
        throw new UnsupportedOperationException();
    }

    public void publishEvent(ApplicationEvent event) {
        throw new UnsupportedOperationException();
    }

    public boolean containsBeanDefinition(String beanName) {
        throw new UnsupportedOperationException();
    }

    public int getBeanDefinitionCount() {
        throw new UnsupportedOperationException();
    }

    public String[] getBeanDefinitionNames() {
        throw new UnsupportedOperationException();
    }

    public String[] getBeanDefinitionNames(Class type) {
        throw new UnsupportedOperationException();
    }

    public String[] getBeanNamesForType(Class type) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator entries = this.beans.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object bean = entry.getValue();
            if (!type.isAssignableFrom(bean.getClass())) continue;
            String name = (String)entry.getKey();
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }

    public String[] getBeanNamesForType(Class type, boolean includePrototypes, boolean includeFactoryBeans) {
        throw new UnsupportedOperationException();
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        throw new UnsupportedOperationException();
    }

    public boolean containsBean(String name) {
        return this.beans.containsKey(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return true;
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException();
    }

    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException();
    }

    public BeanFactory getParentBeanFactory() {
        return null;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        throw new UnsupportedOperationException();
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        throw new UnsupportedOperationException();
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        throw new UnsupportedOperationException();
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Resource getResource(String location) {
        throw new UnsupportedOperationException();
    }

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public boolean containsLocalBean(String arg0) {
        throw new UnsupportedOperationException();
    }

    public ClassLoader getClassLoader() {
        throw new UnsupportedOperationException();
    }
}

