/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring.injection.annot;

import java.lang.reflect.Field;
import junit.framework.TestCase;
import org.apache.wicket.proxy.ILazyInitProxy;
import org.apache.wicket.spring.ISpringContextLocator;
import org.apache.wicket.spring.SpringBeanLocator;
import org.apache.wicket.spring.injection.annot.AnnotProxyFieldValueFactory;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.spring.injection.util.Bean;
import org.apache.wicket.spring.injection.util.Bean2;
import org.apache.wicket.spring.injection.util.Injectable;
import org.apache.wicket.spring.test.ApplicationContextMock;
import org.springframework.context.ApplicationContext;

public class AnnotProxyFieldValueFactoryTest
extends TestCase {
    ISpringContextLocator mockCtxLocator = new ISpringContextLocator(){
        private static final long serialVersionUID = 1L;

        public ApplicationContext getSpringContext() {
            ApplicationContextMock mock = new ApplicationContextMock();
            mock.putBean((Object)new Bean());
            mock.putBean("somebean", (Object)new Bean2());
            return mock;
        }
    };
    Injectable obj = new Injectable();
    AnnotProxyFieldValueFactory factory = new AnnotProxyFieldValueFactory(this.mockCtxLocator);

    public void testFactory() throws Exception {
        SpringBeanLocator locator = null;
        Object proxy = null;
        Field field = this.obj.getClass().getDeclaredField("nobean");
        proxy = this.factory.getFieldValue(field, (Object)this.obj);
        AnnotProxyFieldValueFactoryTest.assertNull((Object)proxy);
        field = this.obj.getClass().getDeclaredField("beanByClass");
        proxy = this.factory.getFieldValue(field, (Object)this.obj);
        locator = (SpringBeanLocator)((ILazyInitProxy)proxy).getObjectLocator();
        AnnotProxyFieldValueFactoryTest.assertTrue((boolean)locator.getBeanType().equals(Bean.class));
        AnnotProxyFieldValueFactoryTest.assertTrue((locator.getSpringContextLocator() == this.mockCtxLocator ? 1 : 0) != 0);
        AnnotProxyFieldValueFactoryTest.assertTrue((boolean)(this.factory.getFieldValue(field, (Object)this.obj) instanceof ILazyInitProxy));
        field = this.obj.getClass().getDeclaredField("beanByName");
        proxy = this.factory.getFieldValue(field, (Object)this.obj);
        locator = (SpringBeanLocator)((ILazyInitProxy)proxy).getObjectLocator();
        AnnotProxyFieldValueFactoryTest.assertTrue((boolean)locator.getBeanName().equals("somebean"));
        AnnotProxyFieldValueFactoryTest.assertTrue((boolean)locator.getBeanType().equals(Bean2.class));
        AnnotProxyFieldValueFactoryTest.assertTrue((locator.getSpringContextLocator() == this.mockCtxLocator ? 1 : 0) != 0);
        AnnotProxyFieldValueFactoryTest.assertTrue((boolean)(this.factory.getFieldValue(field, (Object)this.obj) instanceof ILazyInitProxy));
    }

    public void testCache() throws Exception {
        Object proxy2;
        Field field = this.obj.getClass().getDeclaredField("beanByClass");
        Object proxy1 = this.factory.getFieldValue(field, (Object)this.obj);
        AnnotProxyFieldValueFactoryTest.assertTrue((proxy1 == (proxy2 = this.factory.getFieldValue(field, (Object)this.obj)) ? 1 : 0) != 0);
        field = this.obj.getClass().getDeclaredField("beanByName");
        proxy1 = this.factory.getFieldValue(field, (Object)this.obj);
        proxy2 = this.factory.getFieldValue(field, (Object)this.obj);
        AnnotProxyFieldValueFactoryTest.assertTrue((proxy1 == proxy2 ? 1 : 0) != 0);
    }

    public void testNullContextLocator() {
        try {
            new AnnotProxyFieldValueFactory(null);
            AnnotProxyFieldValueFactoryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFailsIfBeanWithIdIsNotFound() throws Exception {
        InjectableWithReferenceToNonexistingBean obj = new InjectableWithReferenceToNonexistingBean();
        Field field = obj.getClass().getDeclaredField("nonExisting");
        try {
            Bean bean = (Bean)this.factory.getFieldValue(field, (Object)obj);
            bean.method();
            AnnotProxyFieldValueFactoryTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    static class InjectableWithReferenceToNonexistingBean {
        @SpringBean(name="nonExisting")
        private Bean nonExisting;

        InjectableWithReferenceToNonexistingBean() {
        }
    }
}

