/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring.injection.annot;

import org.apache.wicket.Page;
import org.apache.wicket.proxy.ILazyInitProxy;
import org.apache.wicket.spring.Bean;
import org.apache.wicket.spring.SpringBeanLocator;
import org.apache.wicket.spring.injection.annot.AnnotatedBeanNotRequired;
import org.apache.wicket.spring.injection.annot.AnnotatedBeanNotRequiredDifferentName;
import org.apache.wicket.spring.injection.annot.AnnotatedBeanRequired;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.apache.wicket.spring.test.ApplicationContextMock;
import org.apache.wicket.util.tester.WicketTester;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class SpringBeanTest
extends Assert {
    private WicketTester tester;
    private ApplicationContextMock ctx;

    @Before
    public void before() throws Exception {
        this.tester = new WicketTester();
        this.ctx = new ApplicationContextMock();
        SpringComponentInjector springInjector = new SpringComponentInjector(this.tester.getApplication(), (ApplicationContext)this.ctx);
        this.tester.getApplication().getComponentInstantiationListeners().add((Object)springInjector);
    }

    @Test
    public void beanExists() throws Exception {
        this.ctx.putBean("bean", (Object)new Bean());
        AnnotatedBeanRequired page = new AnnotatedBeanRequired();
        this.tester.startPage((Page)page);
        SpringBeanTest.assertNotNull((Object)page.getBean());
        AnnotatedBeanNotRequired notRequiredpage = new AnnotatedBeanNotRequired();
        this.tester.startPage((Page)notRequiredpage);
        SpringBeanTest.assertNotNull((Object)notRequiredpage.getBean());
        SpringBeanTest.assertTrue((page.getBean() == notRequiredpage.getBean() ? 1 : 0) != 0);
    }

    @Test
    public void beanNotExists() throws Exception {
        try {
            this.tester.startPage((Page)new AnnotatedBeanRequired());
            SpringBeanTest.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        AnnotatedBeanNotRequired page = new AnnotatedBeanNotRequired();
        this.tester.startPage((Page)page);
        SpringBeanTest.assertNull((Object)page.getBean());
    }

    @Test
    public void beanExistsDifferentName() throws Exception {
        this.ctx.putBean("mrBean", (Object)new Bean());
        this.ctx.putBean("theBean", (Object)new Bean());
        try {
            this.tester.startPage((Page)new AnnotatedBeanRequired());
            SpringBeanTest.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        AnnotatedBeanNotRequiredDifferentName page = new AnnotatedBeanNotRequiredDifferentName();
        this.tester.startPage((Page)page);
        SpringBeanLocator locator = (SpringBeanLocator)((ILazyInitProxy)page.getBean()).getObjectLocator();
        SpringBeanTest.assertTrue((boolean)locator.getBeanName().equals("mrBean"));
    }
}

