/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring.test;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationContextMock
implements ApplicationContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> beans = new HashMap<String, Object>();

    public void putBean(String name, Object bean) {
        if (this.beans.containsKey(name)) {
            throw new IllegalArgumentException("a bean with name [" + name + "] has already been added to the context");
        }
        this.beans.put(name, bean);
    }

    public void putBean(Object bean) {
        this.putBean(bean.getClass().getName(), bean);
    }

    public Object getBean(String name) throws BeansException {
        Object bean = this.beans.get(name);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(name);
        }
        return bean;
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        Object bean = this.getBean(name);
        if (!requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean.getClass());
        }
        return (T)bean;
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        HashMap<String, Object> found = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
            if (!type.isAssignableFrom(entry.getValue().getClass())) continue;
            found.put(entry.getKey(), entry.getValue());
        }
        return found;
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        Iterator<T> beans = this.getBeansOfType(requiredType).values().iterator();
        if (!beans.hasNext()) {
            throw new NoSuchBeanDefinitionException("bean of required type " + requiredType + " not found");
        }
        T bean = beans.next();
        if (beans.hasNext()) {
            throw new NoSuchBeanDefinitionException("more than one bean of required type " + requiredType + " found");
        }
        return bean;
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        HashMap<String, Object> found = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
            if (!entry.getValue().getClass().isAnnotationPresent(annotationType)) continue;
            found.put(entry.getKey(), entry.getValue());
        }
        return found;
    }

    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) {
        return this.findAnnotationOnClass(this.getBean(beanName).getClass(), annotationType);
    }

    private <A extends Annotation> A findAnnotationOnClass(Class<?> cls, Class<A> annotationType) {
        A annotation = cls.getAnnotation(annotationType);
        if (annotation == null && cls.getSuperclass() != null) {
            annotation = this.findAnnotationOnClass(cls.getSuperclass(), annotationType);
        }
        if (annotation == null) {
            Class<?> intfClass;
            Class<?>[] arr$ = cls.getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (annotation = this.findAnnotationOnClass(intfClass = arr$[i$], annotationType)) == null; ++i$) {
            }
        }
        return annotation;
    }

    public ApplicationContext getParent() {
        throw new UnsupportedOperationException();
    }

    public String getDisplayName() {
        throw new UnsupportedOperationException();
    }

    public long getStartupDate() {
        throw new UnsupportedOperationException();
    }

    public void publishEvent(ApplicationEvent event) {
        throw new UnsupportedOperationException();
    }

    public boolean containsBeanDefinition(String beanName) {
        throw new UnsupportedOperationException();
    }

    public int getBeanDefinitionCount() {
        throw new UnsupportedOperationException();
    }

    public String[] getBeanDefinitionNames() {
        throw new UnsupportedOperationException();
    }

    public String[] getBeanNamesForType(Class type) {
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
            Object bean = entry.getValue();
            if (!type.isAssignableFrom(bean.getClass())) continue;
            names.add(entry.getKey());
        }
        return names.toArray(new String[names.size()]);
    }

    public String[] getBeanNamesForType(Class type, boolean includeNonSingletons, boolean allowEagerInit) {
        throw new UnsupportedOperationException();
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        throw new UnsupportedOperationException();
    }

    public boolean containsBean(String name) {
        return this.beans.containsKey(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return true;
    }

    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException();
    }

    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException();
    }

    public BeanFactory getParentBeanFactory() {
        return null;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        throw new UnsupportedOperationException();
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        throw new UnsupportedOperationException();
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        throw new UnsupportedOperationException();
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Resource getResource(String location) {
        throw new UnsupportedOperationException();
    }

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public boolean containsLocalBean(String arg0) {
        throw new UnsupportedOperationException();
    }

    public ClassLoader getClassLoader() {
        throw new UnsupportedOperationException();
    }

    public String getId() {
        throw new UnsupportedOperationException();
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        throw new UnsupportedOperationException();
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException();
    }

    public boolean isTypeMatch(String name, Class targetType) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException();
    }
}

