/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.resource.IStringResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;

public abstract class AbstractResourceStream
implements IStringResourceStream {
    private static final long serialVersionUID = 1L;
    private Charset charset;
    private Locale locale;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String asString() {
        String string;
        InputStreamReader reader = null;
        try {
            reader = this.charset == null ? new InputStreamReader(this.getInputStream()) : new InputStreamReader(this.getInputStream(), this.charset);
            string = Streams.readString(reader);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unable to read resource as String", e);
                catch (ResourceStreamNotFoundException e2) {
                    throw new RuntimeException("Unable to read resource as String", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                try {
                    this.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        try {
            this.close();
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    protected Charset getCharset() {
        return this.charset;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public long length() {
        return -1L;
    }

    public String getContentType() {
        return null;
    }

    public Time lastModifiedTime() {
        return null;
    }
}

