/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.collections;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MostRecentlyUsedMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    V removedValue;
    private final int maxEntries;

    public MostRecentlyUsedMap(int maxEntries) {
        super(10, 0.75f, true);
        if (maxEntries <= 0) {
            throw new IllegalArgumentException("Must have at least one entry");
        }
        this.maxEntries = maxEntries;
    }

    public Object getRemovedValue() {
        return this.removedValue;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        boolean remove = this.size() > this.maxEntries;
        this.removedValue = remove ? eldest.getValue() : null;
        return remove;
    }
}

