/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipResourceStream
extends AbstractResourceStream {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ZipResourceStream.class);
    private final transient ByteArrayOutputStream bytearray;

    public ZipResourceStream(File dir, boolean recursive) {
        if (dir == null || !dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + dir);
        }
        this.bytearray = new ByteArrayOutputStream();
        try {
            ZipOutputStream out = new ZipOutputStream(this.bytearray);
            ZipResourceStream.zipDir(dir, out, "", recursive);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ZipResourceStream(File dir) {
        this(dir, false);
    }

    private static void zipDir(File dir, ZipOutputStream out, String path, boolean recursive) throws IOException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + dir);
        }
        String[] files = dir.list();
        int BUFFER = 2048;
        BufferedInputStream origin = null;
        byte[] data = new byte[BUFFER];
        for (String file : files) {
            int count;
            File f;
            if (log.isDebugEnabled()) {
                log.debug("Adding: " + file);
            }
            if ((f = new File(dir, file)).isDirectory()) {
                if (!recursive) continue;
                ZipResourceStream.zipDir(f, out, path + f.getName() + "/", recursive);
                continue;
            }
            out.putNextEntry(new ZipEntry(path + f.getName()));
            FileInputStream fi = new FileInputStream(f);
            origin = new BufferedInputStream(fi, BUFFER);
            while ((count = origin.read(data, 0, BUFFER)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
        }
        if (path.equals("")) {
            out.close();
        }
    }

    public void close() throws IOException {
    }

    public String getContentType() {
        return null;
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return new ByteArrayInputStream(this.bytearray.toByteArray());
    }

    public Bytes length() {
        return Bytes.bytes(this.bytearray.size());
    }

    public Time lastModifiedTime() {
        return null;
    }
}

