/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.lang;

import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Args {
    public static <T> T notNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument '" + name + "' may not be null.");
        }
        return argument;
    }

    public static String notEmpty(String argument, String name) {
        if (Strings.isEmpty(argument)) {
            throw new IllegalArgumentException("Argument '" + name + "' may not be null or empty string.");
        }
        return argument;
    }

    public static <T extends Comparable<T>> void withinRange(T min, T max, T value, String name) {
        Args.notNull(min, name);
        Args.notNull(max, name);
        if (value.compareTo(min) < 0 || value.compareTo(max) > 0) {
            throw new IllegalArgumentException(String.format("Argument '%s' must have a value within [%s,%s], but was %s", name, min, max, value));
        }
    }

    public static boolean isTrue(boolean argument, String msg, Object ... params) {
        if (!argument) {
            throw new IllegalArgumentException(Args.format(msg, params));
        }
        return argument;
    }

    public static boolean isFalse(boolean argument, String msg, Object ... params) {
        if (argument) {
            throw new IllegalArgumentException(Args.format(msg, params));
        }
        return argument;
    }

    static String format(String msg, Object ... params) {
        msg = msg.replaceAll("\\{\\}", "%s");
        return String.format(msg, params);
    }
}

