/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.diff;

import java.util.List;
import org.apache.wicket.util.diff.Chunk;
import org.apache.wicket.util.diff.Delta;
import org.apache.wicket.util.diff.Diff;
import org.apache.wicket.util.diff.PatchFailedException;
import org.apache.wicket.util.diff.RevisionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeDelta
extends Delta {
    ChangeDelta() {
    }

    public ChangeDelta(Chunk orig, Chunk rev) {
        this.init(orig, rev);
    }

    @Override
    public void verify(List<Object> target) throws PatchFailedException {
        if (!this.original.verify(target)) {
            throw new PatchFailedException();
        }
        if (this.original.first() > target.size()) {
            throw new PatchFailedException("original.first() > target.size()");
        }
    }

    @Override
    public void applyTo(List<Object> target) {
        this.original.applyDelete(target);
        this.revised.applyAdd(this.original.first(), target);
    }

    @Override
    public void toString(StringBuilder s) {
        this.original.rangeString(s);
        s.append("c");
        this.revised.rangeString(s);
        s.append(Diff.NL);
        this.original.toString(s, "< ", "\n");
        s.append("---");
        s.append(Diff.NL);
        this.revised.toString(s, "> ", "\n");
    }

    @Override
    public void toRCSString(StringBuilder s, String EOL) {
        s.append("d");
        s.append(this.original.rcsfrom());
        s.append(" ");
        s.append(this.original.size());
        s.append(EOL);
        s.append("a");
        s.append(this.original.rcsto());
        s.append(" ");
        s.append(this.revised.size());
        s.append(EOL);
        this.revised.toString(s, "", EOL);
    }

    @Override
    public void accept(RevisionVisitor visitor) {
        visitor.visit(this);
    }
}

