/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.wicket.util.diff.Delta;
import org.apache.wicket.util.diff.Diff;
import org.apache.wicket.util.diff.PatchFailedException;
import org.apache.wicket.util.diff.RevisionVisitor;
import org.apache.wicket.util.diff.ToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Revision
extends ToString {
    List<Delta> deltas_ = new LinkedList<Delta>();

    public synchronized void addDelta(Delta delta) {
        if (delta == null) {
            throw new IllegalArgumentException("new delta is null");
        }
        this.deltas_.add(delta);
    }

    public synchronized void insertDelta(Delta delta) {
        if (delta == null) {
            throw new IllegalArgumentException("new delta is null");
        }
        this.deltas_.add(0, delta);
    }

    public Delta getDelta(int i) {
        return this.deltas_.get(i);
    }

    public int size() {
        return this.deltas_.size();
    }

    public Object[] patch(Object[] src) throws PatchFailedException {
        ArrayList<Object> target = new ArrayList<Object>(Arrays.asList(src));
        this.applyTo(target);
        return target.toArray();
    }

    public synchronized void applyTo(List<Object> target) throws PatchFailedException {
        ListIterator<Delta> i = this.deltas_.listIterator(this.deltas_.size());
        while (i.hasPrevious()) {
            Delta delta = i.previous();
            delta.patch(target);
        }
    }

    @Override
    public synchronized void toString(StringBuilder s) {
        for (Delta delta : this.deltas_) {
            delta.toString(s);
        }
    }

    public synchronized void toRCSString(StringBuilder s, String EOL) {
        for (Delta deltas : this.deltas_) {
            deltas.toRCSString(s, EOL);
        }
    }

    public void toRCSString(StringBuilder s) {
        this.toRCSString(s, Diff.NL);
    }

    public String toRCSString(String EOL) {
        StringBuilder s = new StringBuilder();
        this.toRCSString(s, EOL);
        return s.toString();
    }

    public String toRCSString() {
        return this.toRCSString(Diff.NL);
    }

    public void accept(RevisionVisitor visitor) {
        visitor.visit(this);
        for (Delta delta : this.deltas_) {
            delta.accept(visitor);
        }
    }
}

