/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.util.convert.converter.AbstractConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTimestampConverter
extends AbstractConverter<Timestamp> {
    private static final long serialVersionUID = 1L;
    private final int dateFormat;
    private final int timeFormat;

    public SqlTimestampConverter() {
        this.dateFormat = 3;
        this.timeFormat = 3;
    }

    public SqlTimestampConverter(int dateFormat) {
        this.dateFormat = dateFormat;
        this.timeFormat = 3;
    }

    public SqlTimestampConverter(int dateFormat, int timeFormat) {
        this.dateFormat = dateFormat;
        this.timeFormat = timeFormat;
    }

    @Override
    public Timestamp convertToObject(String value, Locale locale) {
        if (value == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormat format = (DateFormat)DateFormat.getDateTimeInstance(this.dateFormat, this.timeFormat, locale).clone();
        try {
            Date date = format.parse(value);
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            throw this.newConversionException("Cannot parse '" + value + "' using format " + format, value, locale);
        }
    }

    @Override
    public String convertToString(Timestamp timestamp, Locale locale) {
        if (timestamp == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormat format = (DateFormat)DateFormat.getDateTimeInstance(this.dateFormat, this.timeFormat, locale).clone();
        return format.format(timestamp);
    }

    @Override
    protected Class<Timestamp> getTargetType() {
        return Timestamp.class;
    }
}

