/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.DateConverter;
import org.apache.wicket.util.lang.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarConverter
implements IConverter<Calendar> {
    private static final long serialVersionUID = 1L;
    private final IConverter<Date> dateConverter;

    public CalendarConverter() {
        this(new DateConverter());
    }

    public CalendarConverter(IConverter<Date> dateConverter) {
        Args.notNull(dateConverter, "dateConverter");
        this.dateConverter = dateConverter;
    }

    @Override
    public Calendar convertToObject(String value, Locale locale) {
        Date date = this.dateConverter.convertToObject(value, locale);
        if (date == null) {
            return null;
        }
        Calendar calendar = locale != null ? Calendar.getInstance(locale) : Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    @Override
    public String convertToString(Calendar value, Locale locale) {
        if (value == null) {
            return null;
        }
        return this.dateConverter.convertToString(value.getTime(), locale);
    }
}

