/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.watch;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.listener.ChangeListenerSet;
import org.apache.wicket.util.listener.IChangeListener;
import org.apache.wicket.util.thread.ICode;
import org.apache.wicket.util.thread.Task;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.watch.IModifiable;
import org.apache.wicket.util.watch.IModificationWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModificationWatcher
implements IModificationWatcher {
    private static final Logger log = LoggerFactory.getLogger(ModificationWatcher.class);
    private final Map<IModifiable, Entry> modifiableToEntry = new ConcurrentHashMap<IModifiable, Entry>();
    private Task task;

    public ModificationWatcher() {
    }

    public ModificationWatcher(Duration pollFrequency) {
        this.start(pollFrequency);
    }

    @Override
    public final boolean add(IModifiable modifiable, IChangeListener listener) {
        Entry entry = this.modifiableToEntry.get(modifiable);
        if (entry == null) {
            Time lastModifiedTime = modifiable.lastModifiedTime();
            if (lastModifiedTime != null) {
                Entry newEntry = new Entry();
                newEntry.modifiable = modifiable;
                newEntry.lastModifiedTime = lastModifiedTime;
                newEntry.listeners.add(listener);
                this.modifiableToEntry.put(modifiable, newEntry);
            } else {
                log.info("Cannot track modifications to resource " + modifiable);
            }
            return true;
        }
        return !entry.listeners.add(listener);
    }

    @Override
    public IModifiable remove(IModifiable modifiable) {
        Entry entry = this.modifiableToEntry.remove(modifiable);
        if (entry != null) {
            return entry.modifiable;
        }
        return null;
    }

    @Override
    public void start(Duration pollFrequency) {
        this.task = new Task("ModificationWatcher");
        this.task.run(pollFrequency, new ICode(){

            @Override
            public void run(Logger log) {
                for (Entry entry : ModificationWatcher.this.modifiableToEntry.values()) {
                    Time modifiableLastModified = entry.modifiable.lastModifiedTime();
                    if (modifiableLastModified == null || !modifiableLastModified.after(entry.lastModifiedTime)) continue;
                    entry.listeners.notifyListeners();
                    entry.lastModifiedTime = modifiableLastModified;
                }
            }
        });
    }

    @Override
    public void destroy() {
        if (this.task != null) {
            this.task.interrupt();
        }
    }

    @Override
    public final Set<IModifiable> getEntries() {
        return this.modifiableToEntry.keySet();
    }

    private static final class Entry {
        Time lastModifiedTime;
        final ChangeListenerSet listeners = new ChangeListenerSet();
        IModifiable modifiable;

        private Entry() {
        }
    }
}

