/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.lang;

import java.util.Collection;
import org.apache.wicket.util.string.Strings;

public class Args {
    public static <T> T notNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument '" + name + "' may not be null.");
        }
        return argument;
    }

    public static <T extends CharSequence> T notEmpty(T argument, String name) {
        if (Strings.isEmpty(argument)) {
            throw new IllegalArgumentException("Argument '" + name + "' may not be null or empty.");
        }
        return argument;
    }

    public static <T extends Collection<?>> T notEmpty(T collection, String message, Object ... params) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(Args.format(message, params));
        }
        return collection;
    }

    public static <T extends Collection<?>> T notEmpty(T collection, String name) {
        return Args.notEmpty(collection, "Collection '%s' may not be null or empty.", name);
    }

    public static <T extends Comparable<T>> T withinRange(T min, T max, T value, String name) {
        Args.notNull(min, name);
        Args.notNull(max, name);
        if (value.compareTo(min) < 0 || value.compareTo(max) > 0) {
            throw new IllegalArgumentException(String.format("Argument '%s' must have a value within [%s,%s], but was %s", name, min, max, value));
        }
        return value;
    }

    public static boolean isTrue(boolean argument, String msg, Object ... params) {
        if (!argument) {
            throw new IllegalArgumentException(Args.format(msg, params));
        }
        return argument;
    }

    public static boolean isFalse(boolean argument, String msg, Object ... params) {
        if (argument) {
            throw new IllegalArgumentException(Args.format(msg, params));
        }
        return argument;
    }

    static String format(String msg, Object ... params) {
        msg = msg.replaceAll("\\{\\}", "%s");
        return String.format(msg, params);
    }
}

