/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.velocity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.velocity.app.Velocity;
import org.apache.wicket.Application;
import org.apache.wicket.IInitializer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.file.WebApplicationPath;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initializer
implements IInitializer {
    private static final Logger log = LoggerFactory.getLogger((Class)Initializer.class);
    private String velocityPropertiesFile = "velocity.properties";
    private String velocityPropertiesFolder;

    public void init(Application application) {
        Properties props = this.getVelocityProperties(application);
        try {
            if (null != props) {
                Velocity.init((Properties)props);
            } else {
                Velocity.init();
            }
            log.info("Initialized Velocity successfully");
        }
        catch (Exception e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getVelocityProperties(Application application) {
        Properties properties;
        if (application instanceof WebApplication) {
            ServletContext servletContext;
            WebApplication webapp = (WebApplication)application;
            ServletContext sc = servletContext = webapp.getServletContext();
            this.velocityPropertiesFolder = sc.getInitParameter("velocityPropertiesFolder");
            String propsFile = servletContext.getInitParameter("velocity.properties");
            if (null != propsFile) {
                this.velocityPropertiesFile = propsFile;
            }
            if (null != this.velocityPropertiesFolder) {
                Properties properties2;
                WebApplicationPath webPath = new WebApplicationPath(sc);
                webPath.add(this.velocityPropertiesFolder);
                IResourceStream stream = webPath.find(Initializer.class, this.velocityPropertiesFile);
                InputStream is = null;
                try {
                    try {
                        is = stream.getInputStream();
                        Properties props = new Properties();
                        props.load(is);
                        properties2 = props;
                        Object var12_14 = null;
                        if (is == null) return properties2;
                    }
                    catch (IOException e) {
                        throw new WicketRuntimeException((Throwable)e);
                    }
                    catch (ResourceStreamNotFoundException e) {
                        throw new WicketRuntimeException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return properties2;
                }
                is.close();
                return properties2;
            }
        }
        InputStream is = Initializer.class.getResourceAsStream("velocity.properties");
        try {
            try {
                Properties props = new Properties();
                props.load(is);
                properties = props;
                Object var15_19 = null;
                if (is == null) return properties;
            }
            catch (Exception e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return properties;
        }
        is.close();
        return properties;
    }
}

