/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.example.linkbuilders;

import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.wink.common.annotations.Workspace;
import org.apache.wink.common.model.synd.SyndEntry;
import org.apache.wink.common.model.synd.SyndFeed;
import org.apache.wink.common.model.synd.SyndPerson;
import org.apache.wink.common.model.synd.SyndText;
import org.apache.wink.example.linkbuilders.User;
import org.apache.wink.server.utils.LinkBuilders;
import org.apache.wink.server.utils.SingleLinkBuilder;
import org.apache.wink.server.utils.SystemLinksBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Workspace(workspaceTitle="Users Service", collectionTitle="Users")
@Path(value="users")
public class UsersResource {
    private static final String USER_ID = "userId";
    private static final String USER_INFO = "{userId}";
    private static int maxUserID = 0;
    private static HashMap<Integer, User> users = new /* Unavailable Anonymous Inner Class!! */;

    @GET
    @Produces(value={"application/atom+xml"})
    public SyndFeed getUsers(@Context LinkBuilders linkBuilders) {
        SyndFeed usersSyndFeed = this.createUsersSyndFeed(users.values(), linkBuilders);
        return usersSyndFeed;
    }

    private SyndFeed createUsersSyndFeed(Collection<User> users, LinkBuilders linkBuilders) {
        SyndFeed usersSyndFeed = new SyndFeed();
        usersSyndFeed.setId("urn:com:hp:users");
        usersSyndFeed.setTitle(new SyndText("Users"));
        usersSyndFeed.addAuthor(new SyndPerson("admin"));
        usersSyndFeed.setUpdated(new Date());
        linkBuilders.createSystemLinksBuilder().build(usersSyndFeed.getLinks());
        ((SingleLinkBuilder)((SingleLinkBuilder)linkBuilders.createSingleLinkBuilder().queryParam("q", "username")).rel("search").relativize(false)).build(usersSyndFeed.getLinks());
        for (User user : users) {
            SyndEntry userSyndEntry = this.createUserSyndEntry(user);
            ((SystemLinksBuilder)linkBuilders.createSystemLinksBuilder().subResource(userSyndEntry.getId())).build(userSyndEntry.getLinks());
            usersSyndFeed.addEntry(userSyndEntry);
        }
        return usersSyndFeed;
    }

    @Path(value="{userId}")
    @GET
    @Produces(value={"application/atom+xml"})
    public SyndEntry getUserInfo(@PathParam(value="userId") Integer userId, @Context LinkBuilders linkBuilders) throws URISyntaxException {
        User user = (User)users.get(userId);
        if (user == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        SyndEntry userSyndEntry = this.createUserSyndEntry(user);
        linkBuilders.createSystemLinksBuilder().build(userSyndEntry.getLinks());
        return userSyndEntry;
    }

    private SyndEntry createUserSyndEntry(User user) {
        SyndEntry entry = new SyndEntry();
        entry.setId(Integer.toString(user.getId()));
        entry.setPublished(new Date(System.currentTimeMillis()));
        entry.setUpdated(new Date(System.currentTimeMillis()));
        entry.setTitle(new SyndText(user.getLastName() + " " + user.getFirstName()));
        return entry;
    }

    static /* synthetic */ int access$000() {
        return maxUserID;
    }

    static /* synthetic */ int access$004() {
        return ++maxUserID;
    }
}

