/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.providers.jackson;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/json", "text/json"})
@Produces(value={"application/json", "text/json"})
public class WinkJacksonJaxbJsonProvider
extends JacksonJaxbJsonProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    public WinkJacksonJaxbJsonProvider() {
        super(WinkJacksonJaxbJsonProvider.createObjectMapper(), BASIC_ANNOTATIONS);
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        AnnotationIntrospector.Pair pair = new AnnotationIntrospector.Pair((AnnotationIntrospector)new JaxbAnnotationIntrospector(), (AnnotationIntrospector)new JacksonAnnotationIntrospector());
        SerializationConfig serializationConfig = mapper.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_NULL).withAnnotationIntrospector((AnnotationIntrospector)pair);
        DeserializationConfig deserializationConfig = mapper.getDeserializationConfig().without(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES}).withAnnotationIntrospector((AnnotationIntrospector)pair);
        mapper.setSerializationConfig(serializationConfig);
        mapper.setDeserializationConfig(deserializationConfig);
        return mapper;
    }
}

