/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.spring.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.wink.common.DynamicResource;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.LifecycleManager;
import org.apache.wink.common.internal.lifecycle.ObjectCreationException;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;
import org.apache.wink.spring.internal.SpringObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringLifecycleManager<T>
implements LifecycleManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(SpringLifecycleManager.class);
    private Map<Class<?>, SpringObjectFactory> class2factory = new HashMap();
    private Map<String, SpringObjectFactory> id2factory = new HashMap<String, SpringObjectFactory>();

    public ObjectFactory<T> createObjectFactory(T object) throws ObjectCreationException {
        Class<?> cls = object.getClass();
        if (ResourceMetadataCollector.isStaticResource(cls) || ProviderMetadataCollector.isProvider(cls)) {
            return this.class2factory.get(cls);
        }
        if (ResourceMetadataCollector.isDynamicResource(cls)) {
            DynamicResource dynResource = (DynamicResource)object;
            String beanName = dynResource.getBeanName();
            return this.id2factory.get(beanName);
        }
        return null;
    }

    public SpringObjectFactory getSpringObjectFactory(T object, String beanName) {
        Class<?> cls = object.getClass();
        if (ResourceMetadataCollector.isStaticResource(cls) || ProviderMetadataCollector.isProvider(cls)) {
            return this.class2factory.get(cls);
        }
        if (ResourceMetadataCollector.isDynamicResource(cls)) {
            return this.id2factory.get(beanName);
        }
        return null;
    }

    public ObjectFactory<T> createObjectFactory(Class<T> object) throws ObjectCreationException {
        return null;
    }

    public void addResourceOrProvider(Object bean, String beanName, SpringObjectFactory objectFactory) {
        Class<?> cls = bean.getClass();
        if (ResourceMetadataCollector.isStaticResource(cls) || ProviderMetadataCollector.isProvider(cls)) {
            SpringObjectFactory old = this.class2factory.put(cls, objectFactory);
            if (old != null) {
                logger.warn(Messages.getMessage((String)"springClassReplaceNewerObjectFactory"), cls);
            }
        } else {
            logger.warn(Messages.getMessage((String)"springBeanNotResourceNorProvider"), (Object)beanName, cls);
        }
    }

    public void addDynamicResource(Object bean, String beanName, SpringObjectFactory objectFactory) {
        Class<?> cls = bean.getClass();
        if (ResourceMetadataCollector.isDynamicResource(cls)) {
            DynamicResource dynResource = (DynamicResource)bean;
            dynResource.setBeanName(beanName);
            SpringObjectFactory old = this.id2factory.put(beanName, objectFactory);
            if (old != null) {
                logger.warn(Messages.getMessage((String)"springClassReplaceNewerObjectFactory"), (Object)beanName);
            }
        } else {
            logger.warn(Messages.getMessage((String)"springBeanClassNotDynamicResource"), (Object)beanName, cls);
        }
    }
}

