/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.impl;

import java.net.IDN;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import org.apache.wookie.w3c.IAccessEntity;
import org.apache.wookie.w3c.IW3CXMLConfiguration;
import org.apache.wookie.w3c.util.IRIValidator;
import org.apache.wookie.w3c.util.UnicodeUtils;
import org.jdom.Attribute;
import org.jdom.Element;

public class AccessEntity
implements IAccessEntity {
    private String fOrigin = null;
    private boolean fSubDomains = false;

    public String getOrigin() {
        return this.fOrigin;
    }

    public boolean hasSubDomains() {
        return this.fSubDomains;
    }

    public void fromXML(Element element) {
        if (element.getAttribute("origin") == null) {
            return;
        }
        this.fOrigin = UnicodeUtils.normalizeSpaces(element.getAttributeValue("origin"));
        if (this.fOrigin.equals("*")) {
            return;
        }
        try {
            this.processOrigin();
        }
        catch (Exception e) {
            this.fOrigin = null;
            return;
        }
        try {
            this.processSubdomains(element.getAttribute("subdomains"));
        }
        catch (Exception e) {
            this.fSubDomains = false;
            this.fOrigin = null;
        }
    }

    private void processOrigin() throws Exception {
        if (!IRIValidator.isValidIRI(this.fOrigin)) {
            throw new Exception("origin is not a valid IRI");
        }
        URL uri = new URL(this.fOrigin);
        if (uri.getHost() == null || uri.getHost().isEmpty()) {
            throw new Exception("origin has no host");
        }
        if (uri.getUserInfo() != null) {
            throw new Exception("origin has userinfo");
        }
        if (uri.getPath() != null && uri.getPath().length() > 0) {
            throw new Exception("origin has path information");
        }
        if (uri.getRef() != null) {
            throw new Exception("origin has fragment information");
        }
        if (uri.getQuery() != null) {
            throw new Exception("origin has query information");
        }
        if (!Arrays.asList(IW3CXMLConfiguration.SUPPORTED_SCHEMES).contains(uri.getProtocol())) {
            throw new Exception("scheme is not supported");
        }
        int port = uri.getPort();
        if (uri.getProtocol().equals("http") && port == -1) {
            port = 80;
        }
        if (uri.getProtocol().equals("https") && port == -1) {
            port = 443;
        }
        String host = IDN.toASCII(uri.getHost());
        URI processedURI = new URI(uri.getProtocol(), null, host, port, null, null, null);
        this.fOrigin = processedURI.toString();
    }

    private void processSubdomains(Attribute attr) throws Exception {
        if (attr != null) {
            String subDomains = UnicodeUtils.normalizeSpaces(attr.getValue());
            if (subDomains.equals("true") || subDomains.equals("false")) {
                this.fSubDomains = Boolean.valueOf(subDomains);
            } else {
                throw new Exception("subdomains is not a valid boolean value");
            }
        }
    }

    public Element toXml() {
        Element element = new Element("access", "http://www.w3.org/ns/widgets");
        element.setAttribute("subdomains", String.valueOf(this.hasSubDomains()));
        element.setAttribute("origin", this.getOrigin());
        return element;
    }
}

