/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.wookie.w3c.IFeature;
import org.apache.wookie.w3c.IParam;
import org.apache.wookie.w3c.exceptions.BadManifestException;
import org.apache.wookie.w3c.impl.ParamEntity;
import org.apache.wookie.w3c.util.IRIValidator;
import org.apache.wookie.w3c.util.UnicodeUtils;
import org.apache.wookie.w3c.xml.IElement;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureEntity
implements IFeature,
IElement {
    private String fName;
    private boolean fRequired;
    private List<IParam> fParams;
    private String[] features;

    public FeatureEntity(String[] features) {
        this.fName = "";
        this.fRequired = false;
        this.fParams = new ArrayList<IParam>();
        this.features = features;
    }

    public FeatureEntity(String name, boolean required, List<IParam> params) {
        this.fName = name;
        this.fRequired = required;
        this.fParams = params;
    }

    public FeatureEntity(String name, boolean required) {
        this.fName = name;
        this.fRequired = required;
        this.fParams = new ArrayList<IParam>();
    }

    public boolean hasParams() {
        return this.fParams.size() > 0;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public boolean isRequired() {
        return this.fRequired;
    }

    @Override
    public void setRequired(boolean required) {
        this.fRequired = required;
    }

    @Override
    public List<IParam> getParameters() {
        return this.fParams;
    }

    @Override
    public void setParameters(List<IParam> params) {
        this.fParams = params;
    }

    @Override
    public void fromXML(Element element) throws BadManifestException {
        this.fName = UnicodeUtils.normalizeSpaces(element.getAttributeValue("name"));
        this.fRequired = true;
        String isRequired = UnicodeUtils.normalizeSpaces(element.getAttributeValue("required"));
        if (isRequired.equals("false")) {
            this.fRequired = false;
        }
        if (this.fName.equals("")) {
            this.fName = null;
        } else {
            if (!IRIValidator.isValidIRI(this.fName)) {
                if (this.fRequired) {
                    throw new BadManifestException("Feature name is not a valid IRI");
                }
                this.fName = null;
            }
            boolean supported = false;
            if (this.fName != null) {
                for (String supportedFeature : this.features) {
                    if (!this.fName.equalsIgnoreCase(supportedFeature)) continue;
                    supported = true;
                }
            }
            if (!supported) {
                if (this.fRequired) {
                    throw new BadManifestException("Required feature is not supported");
                }
                this.fName = null;
            }
        }
        for (Object o : element.getChildren()) {
            Element child = (Element)o;
            String tag = child.getName();
            if (!tag.equals("param")) continue;
            ParamEntity aParam = new ParamEntity();
            aParam.fromXML(child);
            if (aParam.getName() == null || aParam.getValue() == null) continue;
            this.fParams.add(aParam);
        }
    }

    @Override
    public Element toXml() {
        Element element = new Element("feature", "http://www.w3.org/ns/widgets");
        element.setAttribute("name", this.getName());
        element.setAttribute("required", String.valueOf(this.isRequired()));
        for (IParam param : this.getParameters()) {
            element.addContent((Content)((IElement)((Object)param)).toXml());
        }
        return element;
    }
}

