/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wookie.w3c.IAccess;
import org.apache.wookie.w3c.IAuthor;
import org.apache.wookie.w3c.IContent;
import org.apache.wookie.w3c.IDescription;
import org.apache.wookie.w3c.IFeature;
import org.apache.wookie.w3c.IIcon;
import org.apache.wookie.w3c.ILicense;
import org.apache.wookie.w3c.ILocalized;
import org.apache.wookie.w3c.IName;
import org.apache.wookie.w3c.IPreference;
import org.apache.wookie.w3c.IW3CXMLConfiguration;
import org.apache.wookie.w3c.W3CWidget;
import org.apache.wookie.w3c.exceptions.BadManifestException;
import org.apache.wookie.w3c.impl.AbstractLocalizedEntity;
import org.apache.wookie.w3c.impl.AccessEntity;
import org.apache.wookie.w3c.impl.AuthorEntity;
import org.apache.wookie.w3c.impl.ContentEntity;
import org.apache.wookie.w3c.impl.DescriptionEntity;
import org.apache.wookie.w3c.impl.FeatureEntity;
import org.apache.wookie.w3c.impl.IconEntity;
import org.apache.wookie.w3c.impl.LicenseEntity;
import org.apache.wookie.w3c.impl.NameEntity;
import org.apache.wookie.w3c.impl.PreferenceEntity;
import org.apache.wookie.w3c.updates.UpdateDescription;
import org.apache.wookie.w3c.util.IRIValidator;
import org.apache.wookie.w3c.util.LocalizationUtils;
import org.apache.wookie.w3c.util.NumberUtils;
import org.apache.wookie.w3c.util.RandomGUID;
import org.apache.wookie.w3c.util.UnicodeUtils;
import org.apache.wookie.w3c.util.WidgetPackageUtils;
import org.apache.wookie.w3c.xml.IElement;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetManifestModel
extends AbstractLocalizedEntity
implements W3CWidget,
IElement {
    static Logger fLogger = Logger.getLogger((String)WidgetManifestModel.class.getName());
    private String defaultLocale;
    private String defaultIdentifier;
    private String fIdentifier;
    private String fVersion;
    private Integer fHeight;
    private Integer fWidth;
    private String fViewModes;
    private String[] features;
    private List<IName> fNamesList;
    private List<IDescription> fDescriptionsList;
    private IAuthor fAuthor;
    private List<ILicense> fLicensesList;
    private List<IIcon> fIconsList;
    private List<IAccess> fAccessList;
    private List<IContent> fContentList;
    private List<IFeature> fFeaturesList;
    private List<IPreference> fPreferencesList;
    private String fUpdate;
    private String[] supportedEncodings;
    private ZipFile zip;

    public WidgetManifestModel(String xmlText, String[] locales, String[] features, String[] encodings, ZipFile zip, String defaultIdentifier) throws JDOMException, IOException, BadManifestException {
        boolean exists;
        Element root;
        this.zip = zip;
        this.features = features;
        this.supportedEncodings = encodings;
        this.fNamesList = new ArrayList<IName>();
        this.fDescriptionsList = new ArrayList<IDescription>();
        this.fLicensesList = new ArrayList<ILicense>();
        this.fIconsList = new ArrayList<IIcon>();
        this.fContentList = new ArrayList<IContent>();
        this.fAccessList = new ArrayList<IAccess>();
        this.fFeaturesList = new ArrayList<IFeature>();
        this.fPreferencesList = new ArrayList<IPreference>();
        this.defaultIdentifier = defaultIdentifier;
        SAXBuilder builder = new SAXBuilder();
        try {
            root = builder.build((Reader)new StringReader(xmlText)).getRootElement();
        }
        catch (Exception e) {
            throw new BadManifestException("Config.xml is not well-formed XML");
        }
        this.fromXML(root, locales);
        for (String iconpath : WidgetPackageUtils.getDefaults(zip, locales, IW3CXMLConfiguration.DEFAULT_ICON_FILES)) {
            if (iconpath == null) continue;
            exists = false;
            for (IIcon icon : this.fIconsList) {
                if (!icon.getSrc().equals(iconpath)) continue;
                exists = true;
            }
            if (exists) continue;
            IconEntity i = new IconEntity();
            i.setLang(WidgetPackageUtils.languageTagForPath(iconpath));
            i.setSrc(iconpath);
            this.fIconsList.add(i);
        }
        for (String startpath : WidgetPackageUtils.getDefaults(zip, locales, IW3CXMLConfiguration.START_FILES)) {
            if (startpath == null) continue;
            exists = false;
            for (IContent content : this.fContentList) {
                if (!content.getSrc().equals(startpath)) continue;
                exists = true;
            }
            if (exists) continue;
            ContentEntity c = new ContentEntity();
            c.setLang(WidgetPackageUtils.languageTagForPath(startpath));
            c.setSrc(startpath);
            c.setCharSet("UTF-8");
            if (startpath.endsWith(".htm") || startpath.endsWith(".html")) {
                c.setType("text/html");
            }
            if (startpath.endsWith(".xht") || startpath.endsWith(".xhtml")) {
                c.setType("application/xhtml+xml");
            }
            if (startpath.endsWith(".svg")) {
                c.setType("image/svg+xml");
            }
            this.fContentList.add(c);
        }
    }

    @Override
    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public String getViewModes() {
        return this.fViewModes;
    }

    @Override
    public String getVersion() {
        return this.fVersion;
    }

    @Override
    public List<IPreference> getPreferences() {
        return this.fPreferencesList;
    }

    @Override
    public List<IFeature> getFeatures() {
        return this.fFeaturesList;
    }

    @Override
    public List<IAccess> getAccessList() {
        return this.fAccessList;
    }

    @Override
    public IAuthor getAuthor() {
        return this.fAuthor;
    }

    @Override
    public List<IContent> getContentList() {
        return this.fContentList;
    }

    @Override
    public List<IDescription> getDescriptions() {
        return this.fDescriptionsList;
    }

    @Override
    public List<IName> getNames() {
        return this.fNamesList;
    }

    @Override
    public List<IIcon> getIcons() {
        return this.fIconsList;
    }

    @Override
    public List<ILicense> getLicenses() {
        return this.fLicensesList;
    }

    @Override
    public String getIdentifier() {
        return this.fIdentifier;
    }

    @Override
    public Integer getHeight() {
        return this.fHeight;
    }

    @Override
    public Integer getWidth() {
        return this.fWidth;
    }

    @Override
    public String getUpdateLocation() {
        return this.fUpdate;
    }

    @Override
    public void fromXML(Element element) {
        fLogger.warn((Object)"WidgetManifestModel.fromXML() called with no locales");
        try {
            this.fromXML(element, new String[]{"en"});
        }
        catch (BadManifestException e) {
            fLogger.error((Object)"WidgetManifestModel.fromXML() called with no locales and Bad Manifest", (Throwable)e);
        }
    }

    @Override
    public String getLocalName(String locale) {
        NameEntity name = (NameEntity)LocalizationUtils.getLocalizedElement(this.fNamesList.toArray(new NameEntity[this.fNamesList.size()]), new String[]{locale}, this.defaultLocale);
        if (name != null) {
            return name.getName();
        }
        return "unknown";
    }

    public void updateIconPaths(String path) {
        for (IIcon icon : this.fIconsList) {
            if (icon.getSrc().startsWith("http:")) continue;
            icon.setSrc(path + icon.getSrc());
        }
    }

    public void fromXML(Element element, String[] locales) throws BadManifestException {
        String width;
        if (!element.getNamespace().getURI().equals("http://www.w3.org/ns/widgets")) {
            throw new BadManifestException("'" + element.getNamespace().getURI() + "' is a bad namespace. (Should be '" + "http://www.w3.org/ns/widgets" + "')");
        }
        this.fIdentifier = element.getAttributeValue("id");
        if (this.fIdentifier == null) {
            this.fIdentifier = element.getAttributeValue("uid");
        }
        if (this.fIdentifier != null) {
            this.fIdentifier = UnicodeUtils.normalizeSpaces(this.fIdentifier);
        }
        if (!IRIValidator.isValidIRI(this.fIdentifier)) {
            this.fIdentifier = null;
        }
        if (this.fIdentifier == null) {
            if (this.defaultIdentifier != null) {
                this.fIdentifier = this.defaultIdentifier;
            } else {
                RandomGUID r = new RandomGUID();
                this.fIdentifier = "http://incubator.apache.org/wookie/generated/" + r.toString();
            }
        }
        this.defaultLocale = UnicodeUtils.normalizeSpaces(element.getAttributeValue("defaultlocale"));
        locales = this.addDefaultLocale(locales, this.defaultLocale);
        this.fVersion = UnicodeUtils.normalizeSpaces(element.getAttributeValue("version"));
        String height = element.getAttributeValue("height");
        if (height != null) {
            try {
                this.fHeight = NumberUtils.processNonNegativeInteger(height);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((width = element.getAttributeValue("width")) != null) {
            try {
                this.fWidth = NumberUtils.processNonNegativeInteger(width);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.fViewModes = element.getAttributeValue("viewmodes");
        if (this.fViewModes == null) {
            this.fViewModes = "floating";
        } else {
            this.fViewModes = UnicodeUtils.normalizeSpaces(this.fViewModes);
            String modes = "";
            for (String mode : this.fViewModes.split(" ")) {
                if (!Arrays.asList(IW3CXMLConfiguration.VIEWMODES).contains(mode)) continue;
                modes = modes + mode + " ";
            }
            this.fViewModes = modes.trim();
        }
        super.fromXML(element);
        boolean foundContent = false;
        for (Object o : element.getChildren()) {
            Element child = (Element)o;
            String tag = child.getName();
            if (tag.equals("name")) {
                NameEntity aName = new NameEntity();
                aName.fromXML(child);
                if (this.isFirstLocalizedEntity(this.fNamesList, aName)) {
                    this.fNamesList.add(aName);
                }
            }
            if (tag.equals("description")) {
                DescriptionEntity aDescription = new DescriptionEntity();
                aDescription.fromXML(child);
                if (this.isFirstLocalizedEntity(this.fDescriptionsList, aDescription) && aDescription.isValid()) {
                    this.fDescriptionsList.add(aDescription);
                }
            }
            if (tag.equals("author") && this.fAuthor == null) {
                this.fAuthor = new AuthorEntity();
                ((IElement)((Object)this.fAuthor)).fromXML(child);
            }
            if (tag.equals("update-description") && this.fUpdate == null && child.getNamespace().getURI().equals("http://www.w3.org/ns/widgets")) {
                UpdateDescription update = new UpdateDescription();
                update.fromXML(child);
                if (update.getHref() != null) {
                    this.fUpdate = update.getHref();
                }
            }
            if (tag.equals("license")) {
                LicenseEntity aLicense = new LicenseEntity();
                aLicense.fromXML(child);
                if (this.isFirstLocalizedEntity(this.fLicensesList, aLicense) && aLicense.isValid()) {
                    this.fLicensesList.add(aLicense);
                }
            }
            if (tag.equals("icon")) {
                IconEntity anIcon = new IconEntity();
                anIcon.fromXML(child, locales, this.zip);
                if (anIcon.getSrc() != null) {
                    this.fIconsList.add(anIcon);
                }
            }
            if (tag.equals("access")) {
                AccessEntity access = new AccessEntity();
                ((IElement)access).fromXML(child);
                if (access.getOrigin() != null) {
                    if (access.getOrigin().equals("*")) {
                        this.fAccessList.add(0, access);
                    } else {
                        this.fAccessList.add(access);
                    }
                }
            }
            if (tag.equals("content") && !foundContent) {
                foundContent = true;
                ContentEntity aContent = new ContentEntity();
                aContent.fromXML(child, locales, this.supportedEncodings, this.zip);
                if (aContent.getSrc() != null) {
                    this.fContentList.add(aContent);
                }
            }
            if (tag.equals("feature")) {
                FeatureEntity feature = new FeatureEntity(this.features);
                feature.fromXML(child);
                if (feature.getName() != null) {
                    this.fFeaturesList.add(feature);
                }
            }
            if (!tag.equals("preference")) continue;
            PreferenceEntity preference = new PreferenceEntity();
            preference.fromXML(child);
            if (preference.getName() == null) continue;
            boolean found = false;
            for (IPreference pref : this.getPreferences()) {
                if (!pref.getName().equals(preference.getName())) continue;
                found = true;
            }
            if (found) continue;
            this.fPreferencesList.add(preference);
        }
    }

    private boolean isFirstLocalizedEntity(List list, ILocalized ent) {
        boolean first = true;
        for (ILocalized entity : list.toArray(new ILocalized[list.size()])) {
            if (!StringUtils.equals((String)entity.getLang(), (String)ent.getLang())) continue;
            first = false;
        }
        return first;
    }

    private String[] addDefaultLocale(String[] locales, String defaultLocale) {
        if (defaultLocale == null) {
            return locales;
        }
        if (locales == null) {
            return new String[]{defaultLocale};
        }
        for (String locale : locales) {
            if (!locale.equals(defaultLocale)) continue;
            return locales;
        }
        String[] newLocales = new String[locales.length + 1];
        System.arraycopy(locales, 0, newLocales, 0, locales.length);
        newLocales[newLocales.length - 1] = defaultLocale;
        return newLocales;
    }

    @Override
    public Element toXml() {
        Element widgetElem = new Element("widget", "http://www.w3.org/ns/widgets");
        widgetElem.setAttribute("id", this.getIdentifier());
        if (this.getVersion() != null && this.getVersion().length() > 0) {
            widgetElem.setAttribute("version", this.getVersion());
        }
        if (this.getHeight() != null && this.getHeight() > 0) {
            widgetElem.setAttribute("height", String.valueOf(this.getHeight()));
        }
        if (this.getWidth() != null && this.getWidth() > 0) {
            widgetElem.setAttribute("width", String.valueOf(this.getWidth()));
        }
        if (this.getViewModes() != null) {
            widgetElem.setAttribute("viewmodes", this.getViewModes());
        }
        for (IName name : this.getNames()) {
            Element nameElem = ((IElement)((Object)name)).toXml();
            widgetElem.addContent((Content)nameElem);
        }
        for (IDescription description : this.getDescriptions()) {
            widgetElem.addContent((Content)((IElement)((Object)description)).toXml());
        }
        if (this.getAuthor() != null) {
            widgetElem.addContent((Content)((IElement)((Object)this.getAuthor())).toXml());
        }
        if (this.getUpdateLocation() != null) {
            widgetElem.addContent((Content)new UpdateDescription(this.getUpdateLocation()).toXML());
        }
        for (ILicense license : this.getLicenses()) {
            widgetElem.addContent((Content)((IElement)((Object)license)).toXml());
        }
        for (IIcon icon : this.getIcons()) {
            Element iconElem = ((IElement)((Object)icon)).toXml();
            widgetElem.addContent((Content)iconElem);
        }
        for (IAccess access : this.getAccessList()) {
            Element accessElem = ((IElement)((Object)access)).toXml();
            widgetElem.addContent((Content)accessElem);
        }
        for (IContent content : this.getContentList()) {
            Element contentElem = ((IElement)((Object)content)).toXml();
            widgetElem.addContent((Content)contentElem);
        }
        for (IFeature feature : this.getFeatures()) {
            widgetElem.addContent((Content)((IElement)((Object)feature)).toXml());
        }
        for (IPreference preference : this.getPreferences()) {
            widgetElem.addContent((Content)((IElement)((Object)preference)).toXml());
        }
        return widgetElem;
    }
}

