/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wookie.w3c.util;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * IRI checking utility
 * This should be replaced with a "real" IRI implementation
 * as soon as one becomes available.
 * 
 * @author Scott Wilson
 *
 */
public class IRIValidator {
	
	public static boolean isValidIRI(String str){
		URI iri;
		if (str == null) return false;
		try {
			iri = new URI(str);
			if (iri.getScheme() == null) return false;
			return true;
		} catch (Exception e) {
			// Scheme only is allowed for an IRI
			try {
				new URI(str, null, null);
				return true;
			} catch (URISyntaxException e1) {
				return false;
			}
		}
	}
}
