/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.impl;

import org.apache.wookie.w3c.ILicense;
import org.apache.wookie.w3c.impl.AbstractLocalizedEntity;
import org.apache.wookie.w3c.util.UnicodeUtils;
import org.apache.wookie.w3c.xml.IElement;
import org.jdom.Element;

public class LicenseEntity
extends AbstractLocalizedEntity
implements ILicense,
IElement {
    private String fLicenseText;
    private String fHref;

    public LicenseEntity() {
        this.fLicenseText = "";
    }

    public LicenseEntity(String licenseText, String href, String language, String dir) {
        this.fLicenseText = licenseText;
        this.fHref = href;
        this.setDir(dir);
        this.setLang(language);
    }

    public String getLicenseText() {
        return this.fLicenseText;
    }

    public void setLicenseText(String licenseText) {
        this.fLicenseText = licenseText;
    }

    public String getHref() {
        return this.fHref;
    }

    public void setHref(String href) {
        this.fHref = href;
    }

    public void fromXML(Element element) {
        super.fromXML(element);
        this.fLicenseText = LicenseEntity.getLocalizedTextContent(element);
        this.fHref = UnicodeUtils.normalizeSpaces(element.getAttributeValue("href"));
        if (this.fHref.equals("")) {
            this.fHref = null;
        }
    }

    public Element toXml() {
        Element element = new Element("license", "http://www.w3.org/ns/widgets");
        element.setText(this.getLicenseText());
        if (this.getHref() != null && this.getHref().length() > 0) {
            element.setAttribute("href", this.getHref());
        }
        element = this.setLocalisationAttributes(element);
        return element;
    }
}

