/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class ContentTypeUtils {
    private static final String[] SUPPORTED_IMAGE_TYPES = new String[]{"image/png", "image/jpeg", "image/svg+xml", "image/gif", "image/vnd.microsoft.icon"};

    public static boolean isSupportedImageType(String filename) {
        String type = ContentTypeUtils.getContentType(filename);
        return ContentTypeUtils.isSupported(type, SUPPORTED_IMAGE_TYPES);
    }

    public static boolean isSupportedImageType(File file) {
        if (file == null) {
            return false;
        }
        String type = ContentTypeUtils.getContentType(file);
        return ContentTypeUtils.isSupported(type, SUPPORTED_IMAGE_TYPES);
    }

    private static String getContentType(File file) {
        String type = ContentTypeUtils.getContentType(file.getName());
        if (type == null) {
            try {
                type = ContentTypeUtils.sniffContentType(file);
            }
            catch (IOException e) {
                type = null;
            }
        }
        return type;
    }

    protected static String sniffContentType(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        byte[] bytes = new byte[8];
        stream.read(bytes);
        String[] hex = new String[8];
        String hexString = "";
        for (int i = 0; i < 8; ++i) {
            hex[i] = ContentTypeUtils.getHexValue(bytes[i]);
            hexString = hexString + hex[i] + " ";
        }
        String prefix = new String(bytes);
        if (prefix.startsWith("GIF87") || prefix.startsWith("GIF89")) {
            return "image/gif";
        }
        if (hex[0].equals("ff") && hex[1].equals("d8")) {
            return "image/jpeg";
        }
        if (hex[0].equals("42") && hex[1].equals("4d")) {
            return "image/bmp";
        }
        if (hex[0].equals("00") && hex[1].equals("00") && hex[2].equals("01") && hex[3].equals("00")) {
            return "image/vnd.microsoft.icon";
        }
        if (hexString.trim().equals("89 50 4e 47 0d 0a 1a 0a")) {
            return "image/png";
        }
        return null;
    }

    private static String getHexValue(byte b) {
        String hex = Integer.toHexString(0 | b);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        if (hex.length() > 2) {
            hex = hex.substring(hex.length() - 2);
        }
        return hex;
    }

    private static String getContentType(String filename) {
        if (filename == null) {
            return null;
        }
        if (filename.length() == 0) {
            return null;
        }
        if (filename.endsWith(".")) {
            return null;
        }
        if (filename.startsWith(".") && filename.lastIndexOf(".") == 0) {
            return null;
        }
        if (filename.contains(".")) {
            String type = null;
            String[] parts = filename.split("\\.");
            String ext = parts[parts.length - 1];
            if (ext.length() != 0 && StringUtils.isAlpha((String)ext) && (type = ContentTypeUtils.getContentTypeForExtension(ext)) != null) {
                return type;
            }
        }
        return null;
    }

    private static String getContentTypeForExtension(String ext) {
        if (ext.equals("html")) {
            return "text/html";
        }
        if (ext.equals("htm")) {
            return "text/html";
        }
        if (ext.equals("css")) {
            return "text/css";
        }
        if (ext.equals("js")) {
            return "application/javascript";
        }
        if (ext.equals("xml")) {
            return "application/xml";
        }
        if (ext.equals("txt")) {
            return "text/plain";
        }
        if (ext.equals("wav")) {
            return "audio/x-wav";
        }
        if (ext.equals("xhtml")) {
            return "application/xhtml+xml";
        }
        if (ext.equals("xht")) {
            return "application/xhtml+xml";
        }
        if (ext.equals("gif")) {
            return "image/gif";
        }
        if (ext.equals("png")) {
            return "image/png";
        }
        if (ext.equals("ico")) {
            return "image/vnd.microsoft.icon";
        }
        if (ext.equals("svg")) {
            return "image/svg+xml";
        }
        if (ext.equals("jpg")) {
            return "image/jpeg";
        }
        return null;
    }

    public static boolean isSupported(String value, String[] supportedValues) {
        if (value == null) {
            return false;
        }
        boolean supported = false;
        for (String type : supportedValues) {
            if (!StringUtils.equals((String)value, (String)type)) continue;
            supported = true;
        }
        return supported;
    }
}

