/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.util;

import org.apache.wookie.w3c.IAuthorEntity;
import org.apache.wookie.w3c.IDescriptionEntity;
import org.apache.wookie.w3c.ILicenseEntity;
import org.apache.wookie.w3c.INameEntity;
import org.apache.wookie.w3c.W3CWidget;

public class FormattingUtils {
    public static final String LTR = "\u202a";
    public static final String RTL = "\u202b";
    public static final String LRO = "\u202d";
    public static final String RLO = "\u202e";
    public static final String END = "\u202c";

    public static String getFormattedWidgetName(INameEntity name) {
        return FormattingUtils.getFormatted(name.getDir(), name.getName());
    }

    public static String getFormattedWidgetShortName(INameEntity name) {
        return FormattingUtils.getFormatted(name.getDir(), name.getShort());
    }

    public static String getFormattedWidgetVersion(W3CWidget widget) {
        return FormattingUtils.getFormatted(widget.getDir(), widget.getVersion());
    }

    public static String getFormattedWidgetDescription(IDescriptionEntity description) {
        return FormattingUtils.getFormatted(description.getDir(), description.getDescription());
    }

    public static String getFormattedWidgetAuthor(IAuthorEntity author) {
        return FormattingUtils.getFormatted(author.getDir(), author.getAuthorName());
    }

    public static String getFormattedWidgetLicense(ILicenseEntity license) {
        return FormattingUtils.getFormatted(license.getDir(), license.getLicenseText());
    }

    protected static String getFormatted(String value) {
        value = FormattingUtils.reformatSpan(value);
        return value;
    }

    protected static String getFormatted(String dir, String value) {
        if ((dir == null || dir.equals("ltr")) && !value.contains("dir=")) {
            return value;
        }
        String mode = "embed";
        if (dir == null) {
            dir = "ltr";
        }
        value = FormattingUtils.reformatSpan(value);
        if (dir.equals("lro")) {
            dir = "ltr";
            mode = "bidi-override";
        }
        if (dir.equals("rlo")) {
            dir = "rtl";
            mode = "bidi-override";
        }
        return "<span style=\"unicode-bidi:" + mode + "; direction:" + dir + "\">" + value + "</span>";
    }

    public static String getEncoded(String dir, String value) {
        String checkSpans = FormattingUtils.encodeSpan(value);
        if (checkSpans.equals(value) && dir == null) {
            return value;
        }
        value = checkSpans;
        if (dir == null) {
            return value;
        }
        if (dir.equals("ltr")) {
            dir = LTR;
        }
        if (dir.equals("lro")) {
            dir = LRO;
        }
        if (dir.equals("rlo")) {
            dir = RLO;
        }
        if (dir.equals("rtl")) {
            dir = RTL;
        }
        return dir + value + END;
    }

    private static String encodeSpan(String value) {
        value = value.replace("<span dir=\"ltr\">", LTR);
        value = value.replace("<span dir=\"rtl\">", RTL);
        value = value.replace("<span dir=\"lro\">", LRO);
        value = value.replace("<span dir=\"rlo\">", RLO);
        value = value.replace("</span>", END);
        return value;
    }

    private static String reformatSpan(String value) {
        value = value.replace("span dir=\"rtl\"", "span style=\"unicode-bidi:embed; direction:rtl\"");
        value = value.replace("span dir=\"ltr\"", "span style=\"unicode-bidi:embed; direction:ltr\"");
        value = value.replace("span dir=\"lro\"", "span style=\"unicode-bidi:bidi-override; direction:ltr\"");
        value = value.replace("span dir=\"rlo\"", "span style=\"unicode-bidi:bidi-override; direction:rtl\"");
        return value;
    }
}

