/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.util;

import com.ibm.icu.util.GlobalizationPreferences;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.wookie.w3c.ILocalizedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationUtils {
    static Logger _logger = Logger.getLogger((String)LocalizationUtils.class.getName());

    public static ILocalizedElement getLocalizedElement(ILocalizedElement[] elements, String[] locales, String defaultLocale) {
        ILocalizedElement element = LocalizationUtils.getLocalizedElement(elements, locales);
        if (element == null && elements != null) {
            for (ILocalizedElement elem : elements) {
                if (!elem.getLang().equals(defaultLocale)) continue;
                return elem;
            }
        }
        return element;
    }

    protected static ILocalizedElement getLocalizedElement(ILocalizedElement[] elements, String[] locales) {
        if (elements == null) {
            return null;
        }
        if ((elements = LocalizationUtils.processElementsByLocales(elements, locales)).length == 0) {
            return null;
        }
        return elements[0];
    }

    public static ILocalizedElement[] processElementsByLocales(ILocalizedElement[] elements, String[] locales, String defaultLocale) {
        if (elements == null) {
            return null;
        }
        ILocalizedElement[] filteredElements = LocalizationUtils.processElementsByLocales(elements, locales);
        if (filteredElements == null || filteredElements.length == 0) {
            for (ILocalizedElement element : elements) {
                if (!element.getLang().equals(defaultLocale)) continue;
                return (ILocalizedElement[])ArrayUtils.removeElement((Object[])elements, (Object)element);
            }
        }
        return filteredElements;
    }

    protected static ILocalizedElement[] processElementsByLocales(ILocalizedElement[] elements, String[] locales) {
        if (elements == null) {
            return null;
        }
        List<ULocale> localesList = LocalizationUtils.getProcessedLocaleList(locales);
        Arrays.sort(elements, new LocaleComparator(localesList));
        return LocalizationUtils.filter(elements, localesList);
    }

    public static ILocalizedElement[] processElementsByDefaultLocales(ILocalizedElement[] elements) {
        if (elements == null) {
            return null;
        }
        List<ULocale> localesList = LocalizationUtils.getDefaultLocaleList();
        Arrays.sort(elements, new LocaleComparator(localesList));
        return LocalizationUtils.filter(elements, localesList);
    }

    protected static ILocalizedElement[] filter(ILocalizedElement[] elements, List<ULocale> locales) {
        for (ILocalizedElement element : elements) {
            String lang = element.getLang();
            boolean found = false;
            for (ULocale locale : locales) {
                if (!locale.toLanguageTag().equalsIgnoreCase(lang)) continue;
                found = true;
            }
            if (found || lang == null) continue;
            elements = (ILocalizedElement[])ArrayUtils.removeElement((Object[])elements, (Object)element);
        }
        if (elements.length > 0 && elements[0].getLang() != null) {
            for (ILocalizedElement element : elements) {
                if (element.getLang() != null) continue;
                elements = (ILocalizedElement[])ArrayUtils.removeElement((Object[])elements, (Object)element);
            }
        }
        return elements;
    }

    public static List<ULocale> getProcessedLocaleList(String[] locales) {
        if (locales == null) {
            return LocalizationUtils.getDefaultLocaleList();
        }
        GlobalizationPreferences prefs = new GlobalizationPreferences();
        ArrayList<ULocale> ulocales = new ArrayList<ULocale>();
        for (String locale : locales) {
            if (locale == null) continue;
            try {
                ULocale ulocale = ULocale.forLanguageTag((String)locale);
                if (ulocale.getLanguage().equals("")) continue;
                ulocales.add(ulocale);
            }
            catch (Exception e) {
                _logger.error((Object)("icu4j:ULocale.forLanguageTag(" + locale + ") threw Exception:"), (Throwable)e);
            }
        }
        if (ulocales.isEmpty()) {
            return LocalizationUtils.getDefaultLocaleList();
        }
        prefs.setLocales(ulocales.toArray(new ULocale[ulocales.size()]));
        return prefs.getLocales();
    }

    protected static List<ULocale> getDefaultLocaleList() {
        GlobalizationPreferences prefs = new GlobalizationPreferences();
        return prefs.getLocales();
    }

    public static boolean isValidLanguageTag(String tag) {
        try {
            if (tag.equals("x-w3c-test")) {
                return true;
            }
            ULocale locale = ULocale.forLanguageTag((String)tag);
            if (locale.toLanguageTag() == null) {
                return false;
            }
            if (locale.getExtension("x".charAt(0)) != null) {
                return false;
            }
            return locale.toLanguageTag().equalsIgnoreCase(tag);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LocaleComparator
    implements Comparator<ILocalizedElement> {
        private List<ULocale> locales;

        public LocaleComparator(List<ULocale> locales) {
            this.locales = locales;
        }

        @Override
        public int compare(ILocalizedElement o1, ILocalizedElement o2) {
            if (o1.getLang() != null && o2.getLang() == null) {
                return -1;
            }
            if (o1.getLang() == null && o2.getLang() != null) {
                return 1;
            }
            if (o1.getLang() == null && o2.getLang() == null) {
                return 0;
            }
            int o1i = -1;
            int o2i = -1;
            for (int i = 0; i < this.locales.size(); ++i) {
                if (o1.getLang().equalsIgnoreCase(this.locales.get(i).toLanguageTag())) {
                    o1i = i;
                }
                if (!o2.getLang().equalsIgnoreCase(this.locales.get(i).toLanguageTag())) continue;
                o2i = i;
            }
            if (o1i == -1 && o2i > -1) {
                return 1;
            }
            if (o1i > -1 && o2i == -1) {
                return -1;
            }
            return o1i - o2i;
        }
    }
}

