/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.wookie.w3c.util.LocalizationUtils;

public class WidgetPackageUtils {
    static Logger _logger = Logger.getLogger((String)WidgetPackageUtils.class.getName());

    public static String locateFilePath(String path, String[] locales, ZipFile zip) throws Exception {
        String[] paths = WidgetPackageUtils.locateFilePaths(path, locales, zip);
        if (paths != null && paths.length != 0) {
            return paths[0];
        }
        return null;
    }

    public static String[] locateFilePaths(String path, String[] locales, ZipFile zip) throws Exception {
        String[] pathComponents;
        ArrayList<String> paths = new ArrayList<String>();
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        if ("locales".equalsIgnoreCase((pathComponents = path.split("/"))[0])) {
            if (pathComponents.length < 2) {
                return null;
            }
            if (!LocalizationUtils.isValidLanguageTag(pathComponents[1])) {
                return null;
            }
        }
        for (String locale : locales) {
            String localePath = "locales/" + locale.trim() + "/" + path;
            if (zip.getEntry(localePath) == null) continue;
            if (zip.getEntry(localePath).isDirectory()) {
                throw new Exception();
            }
            paths.add(localePath);
        }
        if (zip.getEntry(path) != null && !zip.getEntry(path).isDirectory()) {
            paths.add(path);
        }
        return paths.toArray(new String[paths.size()]);
    }

    public static String languageTagForPath(String path) {
        if (path == null) {
            return null;
        }
        String locale = null;
        String[] pathComponents = path.split("/");
        if ("locales".equalsIgnoreCase(pathComponents[0])) {
            if (pathComponents.length < 2) {
                return null;
            }
            return pathComponents[1];
        }
        return locale;
    }

    public static String[] getDefaults(ZipFile zip, String[] locales, String[] defaults) {
        ArrayList<String> content = new ArrayList<String>();
        for (String start : defaults) {
            try {
                String[] paths = WidgetPackageUtils.locateFilePaths(start, locales, zip);
                if (paths == null) continue;
                for (String path : paths) {
                    content.add(path);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return content.toArray(new String[content.size()]);
    }

    public static File createUnpackedWidgetFolder(File widgetFolder, String id) throws IOException {
        String folder = WidgetPackageUtils.convertIdToFolderName(id);
        String serverPath = widgetFolder.getPath() + File.separator + folder;
        File file = new File(WidgetPackageUtils.convertPathToPlatform(serverPath));
        return file;
    }

    public static String getURLForWidget(String widgetFolder, String id, String file) {
        String folder = WidgetPackageUtils.convertIdToFolderName(id);
        String path = WidgetPackageUtils.convertPathToRelativeUri(widgetFolder + File.separator + folder + File.separator + file);
        return path;
    }

    public static String convertIdToFolderName(String id) {
        if (id.startsWith("http://")) {
            id = id.substring(7, id.length());
        }
        id = id.replaceAll("[ \\:\"*?<>|`\n\r\t\u0000]+", "");
        return id;
    }

    public static String convertPathToRelativeUri(String path) {
        return path.replace('\\', '/');
    }

    public static String convertPathToPlatform(String path) {
        String result = path.replace('\\', '/').replace('/', File.separatorChar);
        if (result.endsWith(File.separator)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static boolean hasManifest(ZipFile zipfile) {
        return zipfile.getEntry("config.xml") != null;
    }

    public static String extractManifest(ZipFile zipFile) throws IOException {
        ZipArchiveEntry entry = zipFile.getEntry("config.xml");
        return IOUtils.toString((InputStream)zipFile.getInputStream(entry), (String)"UTF-8");
    }

    public static void unpackZip(ZipFile zipfile, File targetFolder) throws IOException {
        targetFolder.mkdirs();
        BufferedOutputStream out = null;
        InputStream in = null;
        Enumeration entries = zipfile.getEntries();
        try {
            while (entries.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)entries.nextElement();
                if (zipEntry.isDirectory()) continue;
                File outFile = new File(targetFolder, zipEntry.getName());
                if (!outFile.getParentFile().exists()) {
                    outFile.getParentFile().mkdirs();
                }
                in = new BufferedInputStream(zipfile.getInputStream(zipEntry));
                out = new BufferedOutputStream(new FileOutputStream(outFile));
                IOUtils.copy((InputStream)in, (OutputStream)out);
                outFile.setLastModified(zipEntry.getTime());
                out.close();
                in.close();
            }
        }
        catch (IOException ex) {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
            throw ex;
        }
    }

    public static void repackZip(File source, File target) throws IOException {
        ZipArchiveOutputStream out = new ZipArchiveOutputStream(target);
        out.setEncoding("UTF-8");
        for (File afile : source.listFiles()) {
            WidgetPackageUtils.pack(afile, out, "");
        }
        out.flush();
        out.close();
    }

    private static void pack(File file, ZipArchiveOutputStream out, String path) throws IOException {
        if (file.isDirectory()) {
            path = path + file.getName() + "/";
            for (File afile : file.listFiles()) {
                WidgetPackageUtils.pack(afile, out, path);
            }
        } else {
            int len;
            ZipArchiveEntry entry = (ZipArchiveEntry)out.createArchiveEntry(file, path + file.getName());
            out.putArchiveEntry((ArchiveEntry)entry);
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(file);
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeArchiveEntry();
        }
    }
}

