/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wookie.w3c.updates;

import java.io.IOException;
import org.apache.wookie.w3c.W3CWidget;
import org.apache.wookie.w3c.W3CWidgetFactory;
import org.apache.wookie.w3c.exceptions.BadManifestException;
import org.apache.wookie.w3c.exceptions.BadWidgetZipFileException;
import org.apache.wookie.w3c.exceptions.InvalidContentTypeException;
import org.apache.wookie.w3c.updates.UpdateDescriptionDocument;

public class UpdateUtils {
    public static UpdateDescriptionDocument checkForUpdate(W3CWidget widget) {
        return UpdateUtils.checkForUpdate(widget.getUpdate(), widget.getVersion());
    }

    public static UpdateDescriptionDocument checkForUpdate(String href, String version) {
        try {
            if (version == null) {
                return null;
            }
            UpdateDescriptionDocument update = new UpdateDescriptionDocument(href);
            if (update.getVersionTag().equals(version)) {
                return null;
            }
            return update;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static W3CWidget getUpdate(W3CWidgetFactory factory, W3CWidget widget) {
        try {
            return UpdateUtils.getUpdate(factory, widget.getIdentifier(), widget.getUpdate(), widget.getVersion(), false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static W3CWidget getUpdate(W3CWidgetFactory factory, String identifier, String href, String version, boolean onlyUseHttps) throws InvalidContentTypeException, BadWidgetZipFileException, BadManifestException, IOException, Exception {
        UpdateDescriptionDocument udd = UpdateUtils.checkForUpdate(href, version);
        if (udd == null) {
            return null;
        }
        if (onlyUseHttps && !udd.getUpdateSource().getProtocol().equalsIgnoreCase("https")) {
            return null;
        }
        W3CWidget updatedWidget = factory.parse(udd.getUpdateSource(), false, identifier);
        return updatedWidget;
    }
}

