/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.axiom.test;

import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.osgi.framework.ServiceReference;

public class ServiceTest extends OSGiTestCase {
	
	public void testLLOMMetaFactoryServicePresent() throws Exception {
		ServiceReference[] omfactRefs = context
				.getServiceReferences("org.apache.axiom.om.OMMetaFactory", "(implementationName=llom)");
		assertNotNull(omfactRefs);
		assertEquals(1, omfactRefs.length);
	}
	
	public void testDOOMMetaFactoryServicePresent() throws Exception {
		ServiceReference[] omfactRefs = context
				.getServiceReferences("org.apache.axiom.om.OMMetaFactory", "(implementationName=doom)");
		assertNotNull(omfactRefs);
		assertEquals(1, omfactRefs.length);
	}
}
