/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.str;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.message.token.SecurityTokenReference;
import org.apache.wss4j.dom.message.token.X509Security;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.str.STRParser;
import org.apache.wss4j.dom.str.STRParserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class EncryptedKeySTRParser
implements STRParser {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedKeySTRParser.class);
    private X509Certificate[] certs;
    private STRParser.REFERENCE_TYPE referenceType;

    @Override
    public void parseSecurityTokenReference(Element strElement, RequestData data, WSDocInfo wsDocInfo, Map<String, Object> parameters) throws WSSecurityException {
        Crypto crypto = data.getDecCrypto();
        SecurityTokenReference secRef = new SecurityTokenReference(strElement, data.getBSPEnforcer());
        String uri = null;
        if (secRef.containsReference()) {
            uri = secRef.getReference().getURI();
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1);
            }
            this.referenceType = STRParser.REFERENCE_TYPE.DIRECT_REF;
        } else if (secRef.containsKeyIdentifier()) {
            uri = secRef.getKeyIdentifierValue();
            this.referenceType = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(secRef.getKeyIdentifierValueType()) ? STRParser.REFERENCE_TYPE.THUMBPRINT_SHA1 : STRParser.REFERENCE_TYPE.KEY_IDENTIFIER;
        }
        WSSecurityEngineResult result = wsDocInfo.getResult(uri);
        if (result != null) {
            this.processPreviousResult(result, secRef, data, wsDocInfo);
        } else if (secRef.containsKeyIdentifier()) {
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(secRef.getKeyIdentifierValueType()) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(secRef.getKeyIdentifierValueType())) {
                SamlAssertionWrapper samlAssertion = STRParserUtil.getAssertionFromKeyIdentifier(secRef, strElement, data, wsDocInfo);
                STRParserUtil.checkSamlTokenBSPCompliance(secRef, samlAssertion, data.getBSPEnforcer());
                SAMLKeyInfo samlKi = SAMLUtil.getCredentialFromSubject((SamlAssertionWrapper)samlAssertion, (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data, wsDocInfo), (Crypto)data.getSigVerCrypto(), (CallbackHandler)data.getCallbackHandler());
                this.certs = samlKi.getCerts();
            } else {
                STRParserUtil.checkBinarySecurityBSPCompliance(secRef, null, data.getBSPEnforcer());
                this.certs = secRef.getKeyIdentifier(crypto);
            }
        } else if (secRef.containsX509Data() || secRef.containsX509IssuerSerial()) {
            this.referenceType = STRParser.REFERENCE_TYPE.ISSUER_SERIAL;
            this.certs = secRef.getX509IssuerSerial(crypto);
        } else if (secRef.containsReference()) {
            Element bstElement = secRef.getTokenElement(strElement.getOwnerDocument(), wsDocInfo, data.getCallbackHandler());
            QName el = new QName(bstElement.getNamespaceURI(), bstElement.getLocalName());
            if (el.equals(WSSecurityEngine.BINARY_TOKEN)) {
                X509Security token = new X509Security(bstElement, data.getBSPEnforcer());
                STRParserUtil.checkBinarySecurityBSPCompliance(secRef, token, data.getBSPEnforcer());
                this.certs = new X509Certificate[]{token.getX509Certificate(crypto)};
            } else {
                throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_SECURITY_TOKEN, "unsupportedBinaryTokenType");
            }
        }
        if (LOG.isDebugEnabled() && this.certs != null && this.certs[0] != null) {
            LOG.debug("cert: " + this.certs[0]);
        }
    }

    @Override
    public X509Certificate[] getCertificates() {
        return this.certs;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public PublicKey getPublicKey() {
        return null;
    }

    @Override
    public byte[] getSecretKey() {
        return null;
    }

    @Override
    public boolean isTrustedCredential() {
        return false;
    }

    @Override
    public STRParser.REFERENCE_TYPE getCertificatesReferenceType() {
        return this.referenceType;
    }

    private void processPreviousResult(WSSecurityEngineResult result, SecurityTokenReference secRef, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        int action = (Integer)result.get("action");
        if (4096 == action) {
            BinarySecurity token = (BinarySecurity)result.get("binary-security-token");
            STRParserUtil.checkBinarySecurityBSPCompliance(secRef, token, data.getBSPEnforcer());
            this.certs = (X509Certificate[])result.get("x509-certificates");
        } else if (8 == action || 16 == action) {
            SamlAssertionWrapper samlAssertion = (SamlAssertionWrapper)result.get("saml-assertion");
            STRParserUtil.checkSamlTokenBSPCompliance(secRef, samlAssertion, data.getBSPEnforcer());
            SAMLKeyInfo keyInfo = SAMLUtil.getCredentialFromSubject((SamlAssertionWrapper)samlAssertion, (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data, wsDocInfo), (Crypto)data.getSigVerCrypto(), (CallbackHandler)data.getCallbackHandler());
            this.certs = keyInfo.getCerts();
        } else {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_SECURITY_TOKEN, "unsupportedBinaryTokenType");
        }
    }
}

