/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util;

import org.osgi.framework.Version;

public class VersionRange {
    private Version low = null;
    private boolean isLowInclusive = false;
    private Version high = null;
    private boolean isHighInclusive = false;
    public static final VersionRange infiniteRange = new VersionRange(Version.emptyVersion, true, null, true);

    public VersionRange(Version low, boolean isLowInclusive, Version high, boolean isHighInclusive) {
        this.low = low;
        this.isLowInclusive = isLowInclusive;
        this.high = high;
        this.isHighInclusive = isHighInclusive;
    }

    public Version getLow() {
        return this.low;
    }

    public boolean isLowInclusive() {
        return this.isLowInclusive;
    }

    public Version getHigh() {
        return this.high;
    }

    public boolean isHighInclusive() {
        return this.isHighInclusive;
    }

    public boolean isInRange(Version version) {
        if (this.high == null) {
            return version.compareTo((Object)this.low) >= 0;
        }
        if (this.isLowInclusive() && this.isHighInclusive()) {
            return version.compareTo((Object)this.low) >= 0 && version.compareTo((Object)this.high) <= 0;
        }
        if (this.isHighInclusive()) {
            return version.compareTo((Object)this.low) > 0 && version.compareTo((Object)this.high) <= 0;
        }
        if (this.isLowInclusive()) {
            return version.compareTo((Object)this.low) >= 0 && version.compareTo((Object)this.high) < 0;
        }
        return version.compareTo((Object)this.low) > 0 && version.compareTo((Object)this.high) < 0;
    }

    public static VersionRange parse(String range) {
        if (range.indexOf(44) >= 0) {
            String s = range.substring(1, range.length() - 1);
            String vlo = s.substring(0, s.indexOf(44)).trim();
            String vhi = s.substring(s.indexOf(44) + 1, s.length()).trim();
            return new VersionRange(new Version(vlo), range.charAt(0) == '[', new Version(vhi), range.charAt(range.length() - 1) == ']');
        }
        return new VersionRange(new Version(range), true, null, false);
    }

    public String toString() {
        if (this.high != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.isLowInclusive ? (char)'[' : '(');
            sb.append(this.low.toString());
            sb.append(',');
            sb.append(this.high.toString());
            sb.append(this.isHighInclusive ? (char)']' : ')');
            return sb.toString();
        }
        return this.low.toString();
    }
}

