/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xbean.asm6.AnnotationVisitor;
import org.apache.xbean.asm6.ClassReader;
import org.apache.xbean.asm6.ClassVisitor;
import org.apache.xbean.asm6.FieldVisitor;
import org.apache.xbean.asm6.MethodVisitor;
import org.apache.xbean.asm6.shade.commons.EmptyVisitor;
import org.apache.xbean.finder.Annotated;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.MetaAnnotatedClass;
import org.apache.xbean.finder.MetaAnnotatedField;
import org.apache.xbean.finder.MetaAnnotatedMethod;
import org.apache.xbean.finder.util.SingleLinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFinder
implements IAnnotationFinder {
    private final Map<String, List<Info>> annotated = new HashMap<String, List<Info>>();
    protected final Map<String, ClassInfo> classInfos = new HashMap<String, ClassInfo>();
    protected final Map<String, ClassInfo> originalInfos = new HashMap<String, ClassInfo>();
    private final List<String> classesNotLoaded = new ArrayList<String>();
    private final int ASM_FLAGS = 7;

    protected abstract URL getResource(String var1);

    protected abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    @Override
    public List<String> getAnnotatedClassNames() {
        return new ArrayList<String>(this.originalInfos.keySet());
    }

    public AbstractFinder link() throws IOException {
        if (this.originalInfos.size() > 0) {
            return this;
        }
        this.originalInfos.putAll(this.classInfos);
        for (ClassInfo classInfo : this.classInfos.values().toArray(new ClassInfo[this.classInfos.size()])) {
            this.linkParent(classInfo);
        }
        for (ClassInfo classInfo : this.classInfos.values().toArray(new ClassInfo[this.classInfos.size()])) {
            this.linkInterfaces(classInfo);
        }
        return this;
    }

    private void linkParent(ClassInfo classInfo) throws IOException {
        if (classInfo.superType == null) {
            return;
        }
        if (classInfo.superType.equals("java.lang.Object")) {
            return;
        }
        ClassInfo parentInfo = classInfo.superclassInfo;
        if (parentInfo == null) {
            parentInfo = this.classInfos.get(classInfo.superType);
            if (parentInfo == null) {
                if (classInfo.clazz != null) {
                    this.readClassDef(classInfo.clazz.getSuperclass());
                } else {
                    this.readClassDef(classInfo.superType);
                }
                parentInfo = this.classInfos.get(classInfo.superType);
                if (parentInfo == null) {
                    return;
                }
                this.linkParent(parentInfo);
            }
            classInfo.superclassInfo = parentInfo;
        }
        if (!parentInfo.subclassInfos.contains(classInfo)) {
            parentInfo.subclassInfos.add(classInfo);
        }
    }

    private void linkInterfaces(ClassInfo classInfo) throws IOException {
        ArrayList<ClassInfo> infos = new ArrayList<ClassInfo>();
        if (classInfo.clazz != null) {
            Class<?>[] interfaces;
            for (Class<?> clazz : interfaces = classInfo.clazz.getInterfaces()) {
                ClassInfo interfaceInfo = this.classInfos.get(clazz.getName());
                if (interfaceInfo == null) {
                    this.readClassDef(clazz);
                }
                if ((interfaceInfo = this.classInfos.get(clazz.getName())) == null) continue;
                infos.add(interfaceInfo);
            }
        } else {
            for (String className : classInfo.interfaces) {
                ClassInfo interfaceInfo = this.classInfos.get(className);
                if (interfaceInfo == null) {
                    this.readClassDef(className);
                }
                if ((interfaceInfo = this.classInfos.get(className)) == null) continue;
                infos.add(interfaceInfo);
            }
        }
        for (ClassInfo info : infos) {
            this.linkInterfaces(info);
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        List<Info> infos = this.annotated.get(annotation.getName());
        return infos != null && !infos.isEmpty();
    }

    @Override
    public List<String> getClassesNotLoaded() {
        return Collections.unmodifiableList(this.classesNotLoaded);
    }

    @Override
    public List<Package> findAnnotatedPackages(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<Package> packages = new ArrayList<Package>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            if (!(info instanceof PackageInfo)) continue;
            PackageInfo packageInfo = (PackageInfo)info;
            try {
                Package pkg = packageInfo.get();
                if (!pkg.isAnnotationPresent(annotation)) continue;
                packages.add(pkg);
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(packageInfo.getName());
            }
        }
        return packages;
    }

    @Override
    public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            if (!(info instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)info;
            try {
                Class<?> clazz = classInfo.get();
                if (!clazz.isAnnotationPresent(annotation)) continue;
                classes.add(clazz);
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    @Override
    public List<Annotated<Class<?>>> findMetaAnnotatedClasses(Class<? extends Annotation> annotation) {
        List<Class<?>> classes = this.findAnnotatedClasses(annotation);
        ArrayList list = new ArrayList();
        for (Class<?> clazz : classes) {
            list.add(new MetaAnnotatedClass(clazz));
        }
        return list;
    }

    @Override
    public List<Class<?>> findInheritedAnnotatedClasses(Class<? extends Annotation> annotation) {
        boolean annClassFound;
        this.classesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            try {
                if (!(info instanceof ClassInfo)) continue;
                classes.add(((ClassInfo)info).get());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        ArrayList<ClassInfo> tempClassInfos = new ArrayList<ClassInfo>(this.classInfos.values());
        do {
            annClassFound = false;
            for (int pos = 0; pos < tempClassInfos.size(); ++pos) {
                ClassInfo classInfo = (ClassInfo)tempClassInfos.get(pos);
                try {
                    String superType = classInfo.getSuperType();
                    for (Class clazz : classes) {
                        if (!superType.equals(clazz.getName())) continue;
                        classes.add(classInfo.get());
                        tempClassInfos.remove(pos);
                        annClassFound = true;
                        break;
                    }
                    List<String> interfces = classInfo.getInterfaces();
                    block9: for (String interfce : interfces) {
                        for (Class clazz : classes) {
                            if (!interfce.replaceFirst("<.*>", "").equals(clazz.getName())) continue;
                            classes.add(classInfo.get());
                            tempClassInfos.remove(pos);
                            annClassFound = true;
                            continue block9;
                        }
                    }
                    continue;
                }
                catch (ClassNotFoundException e) {
                    this.classesNotLoaded.add(classInfo.getName());
                    continue;
                }
                catch (NoClassDefFoundError e) {
                    this.classesNotLoaded.add(classInfo.getName());
                }
            }
        } while (annClassFound);
        return classes;
    }

    @Override
    public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Method> methods = new ArrayList<Method>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            MethodInfo methodInfo;
            ClassInfo classInfo;
            if (!(info instanceof MethodInfo) || info.getName().equals("<init>") || seen.contains(classInfo = (methodInfo = (MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class<?> clazz = classInfo.get();
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    methods.add(method);
                }
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return methods;
    }

    @Override
    public List<Annotated<Method>> findMetaAnnotatedMethods(Class<? extends Annotation> annotation) {
        List<Method> methods = this.findAnnotatedMethods(annotation);
        ArrayList<Annotated<Method>> list = new ArrayList<Annotated<Method>>();
        for (Method method : methods) {
            list.add(new MetaAnnotatedMethod(method));
        }
        return list;
    }

    @Override
    public List<Constructor> findAnnotatedConstructors(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Constructor> constructors = new ArrayList<Constructor>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            MethodInfo methodInfo;
            ClassInfo classInfo;
            if (!(info instanceof MethodInfo) || !info.getName().equals("<init>") || seen.contains(classInfo = (methodInfo = (MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class<?> clazz = classInfo.get();
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (!constructor.isAnnotationPresent(annotation)) continue;
                    constructors.add(constructor);
                }
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return constructors;
    }

    @Override
    public List<Field> findAnnotatedFields(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Field> fields = new ArrayList<Field>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            FieldInfo fieldInfo;
            ClassInfo classInfo;
            if (!(info instanceof FieldInfo) || seen.contains(classInfo = (fieldInfo = (FieldInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class<?> clazz = classInfo.get();
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    fields.add(field);
                }
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return fields;
    }

    @Override
    public List<Annotated<Field>> findMetaAnnotatedFields(Class<? extends Annotation> annotation) {
        List<Field> fields = this.findAnnotatedFields(annotation);
        ArrayList<Annotated<Field>> list = new ArrayList<Annotated<Field>>();
        for (Field field : fields) {
            list.add(new MetaAnnotatedField(field));
        }
        return list;
    }

    @Override
    public List<Class<?>> findClassesInPackage(String packageName, boolean recursive) {
        this.classesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        for (ClassInfo classInfo : this.classInfos.values()) {
            try {
                if (recursive && classInfo.getPackageName().startsWith(packageName)) {
                    classes.add(classInfo.get());
                    continue;
                }
                if (!classInfo.getPackageName().equals(packageName)) continue;
                classes.add(classInfo.get());
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    @Override
    public <T> List<Class<? extends T>> findSubclasses(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("class cannot be null");
        }
        this.classesNotLoaded.clear();
        ClassInfo classInfo = this.classInfos.get(clazz.getName());
        ArrayList<Class<? extends T>> found = new ArrayList<Class<? extends T>>();
        if (classInfo == null) {
            return found;
        }
        this.findSubclasses(classInfo, found, clazz);
        return found;
    }

    private <T> void findSubclasses(ClassInfo classInfo, List<Class<? extends T>> found, Class<T> clazz) {
        for (ClassInfo subclassInfo : classInfo.subclassInfos) {
            try {
                found.add(subclassInfo.get().asSubclass(clazz));
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(subclassInfo.getName());
            }
            this.findSubclasses(subclassInfo, found, clazz);
        }
    }

    private <T> List<Class<? extends T>> _findSubclasses(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("class cannot be null");
        }
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        for (ClassInfo classInfo : this.classInfos.values()) {
            try {
                if (!clazz.getName().equals(classInfo.superType) || !clazz.isAssignableFrom(classInfo.get())) continue;
                classes.add(classInfo.get().asSubclass(clazz));
                classes.addAll(this._findSubclasses(classInfo.get().asSubclass(clazz)));
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    @Override
    public <T> List<Class<? extends T>> findImplementations(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("class cannot be null");
        }
        if (!clazz.isInterface()) {
            new IllegalArgumentException("class must be an interface");
        }
        this.classesNotLoaded.clear();
        String interfaceName = clazz.getName();
        List<ClassInfo> infos = this.collectImplementations(interfaceName);
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        for (ClassInfo info : infos) {
            try {
                Class<?> impl = info.get();
                if (!clazz.isAssignableFrom(impl)) continue;
                classes.add(impl);
                classes.addAll(this._findSubclasses(impl));
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(info.getName());
            }
        }
        return classes;
    }

    private List<ClassInfo> collectImplementations(String interfaceName) {
        ArrayList<ClassInfo> infos = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : this.classInfos.values()) {
            if (!classInfo.interfaces.contains(interfaceName)) continue;
            infos.add(classInfo);
            try {
                Class<?> clazz = classInfo.get();
                if (!clazz.isInterface() || clazz.isAnnotation()) continue;
                infos.addAll(this.collectImplementations(classInfo.name));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return infos;
    }

    protected List<Info> getAnnotationInfos(String name) {
        List<Info> infos = this.annotated.get(name);
        if (infos == null) {
            infos = new SingleLinkedList<Info>();
            this.annotated.put(name, infos);
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readClassDef(String className) {
        block9: {
            int pos = className.indexOf("<");
            if (pos > -1) {
                className = className.substring(0, pos);
            }
            if ((pos = className.indexOf(">")) > -1) {
                className = className.substring(0, pos);
            }
            if (!className.endsWith(".class")) {
                className = className.replace('.', '/') + ".class";
            }
            try {
                URL resource = this.getResource(className);
                if (resource != null) {
                    InputStream in = resource.openStream();
                    try {
                        this.readClassDef(in);
                        break block9;
                    }
                    finally {
                        in.close();
                    }
                }
                this.classesNotLoaded.add(className + " (no resource found for class)");
            }
            catch (IOException e) {
                this.classesNotLoaded.add(className + e.getMessage());
            }
        }
    }

    protected void readClassDef(InputStream in) throws IOException {
        this.readClassDef(in, null);
    }

    protected void readClassDef(InputStream in, String path) throws IOException {
        ClassReader classReader = new ClassReader(in);
        classReader.accept((ClassVisitor)new InfoBuildingVisitor(path), 7);
    }

    protected void readClassDef(Class clazz) {
        ArrayList<Annotatable> infos = new ArrayList<Annotatable>();
        Package aPackage = clazz.getPackage();
        if (aPackage != null) {
            PackageInfo info = new PackageInfo(aPackage);
            for (AnnotationInfo annotationInfo : info.getAnnotations()) {
                List<Info> annotationInfos = this.getAnnotationInfos(annotationInfo.getName());
                if (annotationInfos.contains(info)) continue;
                annotationInfos.add(info);
            }
        }
        ClassInfo classInfo = new ClassInfo(clazz);
        infos.add(classInfo);
        this.classInfos.put(clazz.getName(), classInfo);
        for (Method method : clazz.getDeclaredMethods()) {
            infos.add(new MethodInfo(classInfo, method));
        }
        for (Executable executable : clazz.getConstructors()) {
            infos.add(new MethodInfo(classInfo, (Constructor)executable));
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            infos.add(new FieldInfo(classInfo, (Field)accessibleObject));
        }
        for (Info info : infos) {
            for (AnnotationInfo annotationInfo : info.getAnnotations()) {
                List<Info> annotationInfos = this.getAnnotationInfos(annotationInfo.getName());
                annotationInfos.add(info);
            }
        }
    }

    public class InfoBuildingVisitor
    extends EmptyVisitor {
        private Info info;
        private String path;

        public InfoBuildingVisitor(String path) {
            this.path = path;
        }

        public InfoBuildingVisitor(Info info) {
            this.info = info;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (name.endsWith("package-info")) {
                this.info = new PackageInfo(this.javaName(name));
            } else {
                ClassInfo classInfo = new ClassInfo(this.javaName(name), this.javaName(superName));
                classInfo.path = this.path;
                for (String interfce : interfaces) {
                    classInfo.getInterfaces().add(this.javaName(interfce));
                }
                this.info = classInfo;
                AbstractFinder.this.classInfos.put(classInfo.getName(), classInfo);
            }
        }

        private String javaName(String name) {
            return name == null ? null : name.replace('/', '.');
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationInfo annotationInfo = new AnnotationInfo(desc);
            this.info.getAnnotations().add(annotationInfo);
            AbstractFinder.this.getAnnotationInfos(annotationInfo.getName()).add(this.info);
            return new InfoBuildingVisitor(annotationInfo).annotationVisitor();
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ClassInfo classInfo = (ClassInfo)this.info;
            FieldInfo fieldInfo = new FieldInfo(classInfo, name, desc);
            classInfo.getFields().add(fieldInfo);
            return new InfoBuildingVisitor(fieldInfo).fieldVisitor();
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            ClassInfo classInfo = (ClassInfo)this.info;
            MethodInfo methodInfo = new MethodInfo(classInfo, name, desc);
            classInfo.getMethods().add(methodInfo);
            return new InfoBuildingVisitor(methodInfo).methodVisitor();
        }

        public AnnotationVisitor visitMethodParameterAnnotation(int param, String desc, boolean visible) {
            MethodInfo methodInfo = (MethodInfo)this.info;
            List<AnnotationInfo> annotationInfos = methodInfo.getParameterAnnotations(param);
            AnnotationInfo annotationInfo = new AnnotationInfo(desc);
            annotationInfos.add(annotationInfo);
            return new InfoBuildingVisitor(annotationInfo).annotationVisitor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AnnotationInfo
    extends Annotatable
    implements Info {
        private final String name;

        public AnnotationInfo(Annotation annotation) {
            this(annotation.getClass().getName());
        }

        public AnnotationInfo(Class<? extends Annotation> annotation) {
            this.name = annotation.getName().intern();
        }

        public AnnotationInfo(String name) {
            name = name.replaceAll("^L|;$", "");
            name = name.replace('/', '.');
            this.name = name.intern();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public class FieldInfo
    extends Annotatable
    implements Info {
        private final String name;
        private final String type;
        private final ClassInfo declaringClass;

        public FieldInfo(ClassInfo info, Field field) {
            super(field);
            this.declaringClass = info;
            this.name = field.getName();
            this.type = field.getType().getName();
        }

        public FieldInfo(ClassInfo declaringClass, String name, String type) {
            this.declaringClass = declaringClass;
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public ClassInfo getDeclaringClass() {
            return this.declaringClass;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.declaringClass + "#" + this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MethodInfo
    extends Annotatable
    implements Info {
        private final ClassInfo declaringClass;
        private final String returnType;
        private final String name;
        private final List<List<AnnotationInfo>> parameterAnnotations;

        public MethodInfo(ClassInfo info, Constructor constructor) {
            super(constructor);
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = info;
            this.name = "<init>";
            this.returnType = Void.TYPE.getName();
        }

        public MethodInfo(ClassInfo info, Method method) {
            super(method);
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = info;
            this.name = method.getName();
            this.returnType = method.getReturnType().getName();
        }

        public MethodInfo(ClassInfo declarignClass, String name, String returnType) {
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = declarignClass;
            this.name = name;
            this.returnType = returnType;
        }

        public List<List<AnnotationInfo>> getParameterAnnotations() {
            return this.parameterAnnotations;
        }

        public List<AnnotationInfo> getParameterAnnotations(int index) {
            if (index >= this.parameterAnnotations.size()) {
                for (int i = this.parameterAnnotations.size(); i <= index; ++i) {
                    ArrayList annotationInfos = new ArrayList();
                    this.parameterAnnotations.add(i, annotationInfos);
                }
            }
            return this.parameterAnnotations.get(index);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public ClassInfo getDeclaringClass() {
            return this.declaringClass;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public String toString() {
            return this.declaringClass + "@" + this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClassInfo
    extends Annotatable
    implements Info {
        private String name;
        private final List<MethodInfo> methods;
        private final List<MethodInfo> constructors;
        private String superType;
        private ClassInfo superclassInfo;
        private final List<ClassInfo> subclassInfos;
        private final List<String> interfaces;
        private final List<FieldInfo> fields;
        private String path;
        private Class<?> clazz;

        public ClassInfo(Class clazz) {
            super(clazz);
            this.methods = new SingleLinkedList<MethodInfo>();
            this.constructors = new SingleLinkedList<MethodInfo>();
            this.subclassInfos = new SingleLinkedList<ClassInfo>();
            this.interfaces = new SingleLinkedList<String>();
            this.fields = new SingleLinkedList<FieldInfo>();
            this.clazz = clazz;
            this.name = clazz.getName();
            Class superclass = clazz.getSuperclass();
            this.superType = superclass != null ? superclass.getName() : null;
            for (Class<?> intrface : clazz.getInterfaces()) {
                this.interfaces.add(intrface.getName());
            }
        }

        public ClassInfo(String name, String superType) {
            this.methods = new SingleLinkedList<MethodInfo>();
            this.constructors = new SingleLinkedList<MethodInfo>();
            this.subclassInfos = new SingleLinkedList<ClassInfo>();
            this.interfaces = new SingleLinkedList<String>();
            this.fields = new SingleLinkedList<FieldInfo>();
            this.name = name;
            this.superType = superType;
        }

        public String getPackageName() {
            return this.name.indexOf(".") > 0 ? this.name.substring(0, this.name.lastIndexOf(".")) : "";
        }

        public List<MethodInfo> getConstructors() {
            return this.constructors;
        }

        public List<String> getInterfaces() {
            return this.interfaces;
        }

        public List<FieldInfo> getFields() {
            return this.fields;
        }

        public List<MethodInfo> getMethods() {
            return this.methods;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getSuperType() {
            return this.superType;
        }

        public Class<?> get() throws ClassNotFoundException {
            if (this.clazz != null) {
                return this.clazz;
            }
            try {
                String fixedName = this.name.replaceFirst("<.*>", "");
                this.clazz = AbstractFinder.this.loadClass(fixedName);
                return this.clazz;
            }
            catch (ClassNotFoundException notFound) {
                AbstractFinder.this.classesNotLoaded.add(this.name);
                throw notFound;
            }
        }

        public String toString() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }
    }

    public class PackageInfo
    extends Annotatable
    implements Info {
        private final String name;
        private final ClassInfo info;
        private final Package pkg;

        public PackageInfo(Package pkg) {
            super(pkg);
            this.pkg = pkg;
            this.name = pkg.getName();
            this.info = null;
        }

        public PackageInfo(String name) {
            this.info = new ClassInfo(name, null);
            this.name = name;
            this.pkg = null;
        }

        public String getName() {
            return this.name;
        }

        public Package get() throws ClassNotFoundException {
            return this.pkg != null ? this.pkg : this.info.get().getPackage();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PackageInfo that = (PackageInfo)o;
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Info {
        public String getName();

        public List<AnnotationInfo> getAnnotations();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Annotatable {
        private final List<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>();

        public Annotatable(AnnotatedElement element) {
            for (Annotation annotation : this.getAnnotations(element)) {
                this.annotations.add(new AnnotationInfo(annotation.annotationType().getName()));
            }
        }

        public Annotatable() {
        }

        public List<AnnotationInfo> getAnnotations() {
            return this.annotations;
        }

        private Annotation[] getAnnotations(AnnotatedElement element) {
            try {
                return element.getAnnotations();
            }
            catch (LinkageError e) {
                return element.getAnnotations();
            }
        }
    }
}

