/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.archive;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xbean.finder.archive.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassesArchive
implements Archive {
    private final Set<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();
    private final Map<String, Class<?>> classes = new LinkedHashMap();

    public ClassesArchive(Class<?> ... classes) {
        this(Arrays.asList(classes));
    }

    public ClassesArchive(Iterable<Class<?>> classes) {
        assert (classes != null);
        for (Class<?> clazz : classes) {
            if (clazz == null || clazz.getClassLoader() == null) continue;
            this.classes.put(clazz.getName(), clazz);
            this.loaders.add(clazz.getClassLoader());
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.classes.keySet().iterator();
    }

    @Override
    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        assert (className != null);
        int pos = className.indexOf("<");
        if (pos > -1) {
            className = className.substring(0, pos);
        }
        if ((pos = className.indexOf(">")) > -1) {
            className = className.substring(0, pos);
        }
        if (!className.endsWith(".class")) {
            className = className.replace('.', '/') + ".class";
        }
        for (ClassLoader loader : this.loaders) {
            URL resource = loader.getResource(className);
            if (resource == null) continue;
            return new BufferedInputStream(resource.openStream());
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> clazz = this.classes.get(className);
        if (clazz != null) {
            return clazz;
        }
        for (ClassLoader loader : this.loaders) {
            try {
                return loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(className);
    }
}

