/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.xbean.osgi.bundle.util.BundleDescription;
import org.apache.xbean.osgi.bundle.util.DiscoveryRange;
import org.apache.xbean.osgi.bundle.util.ResourceDiscoveryFilter;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleResourceFinder {
    public static final ResourceDiscoveryFilter FULL_DISCOVERY_FILTER = new DummyDiscoveryFilter();
    private final Bundle bundle;
    private final PackageAdmin packageAdmin;
    private final String prefix;
    private final String suffix;
    private ResourceDiscoveryFilter discoveryFilter;

    public BundleResourceFinder(PackageAdmin packageAdmin, Bundle bundle, String prefix, String suffix) {
        this(packageAdmin, bundle, prefix, suffix, FULL_DISCOVERY_FILTER);
    }

    public BundleResourceFinder(PackageAdmin packageAdmin, Bundle bundle, String prefix, String suffix, ResourceDiscoveryFilter discoveryFilter) {
        this.packageAdmin = packageAdmin;
        this.bundle = bundle;
        this.prefix = prefix.trim();
        this.suffix = suffix.trim();
        this.discoveryFilter = discoveryFilter;
    }

    public void find(ResourceFinderCallback callback) throws Exception {
        Bundle[] fragments;
        if (this.discoveryFilter.rangeDiscoveryRequired(DiscoveryRange.BUNDLE_CLASSPATH)) {
            this.scanBundleClassPath(callback, this.bundle);
        }
        if (this.packageAdmin != null && this.discoveryFilter.rangeDiscoveryRequired(DiscoveryRange.FRAGMENT_BUNDLES) && (fragments = this.packageAdmin.getFragments(this.bundle)) != null) {
            for (Bundle fragment : fragments) {
                this.scanBundleClassPath(callback, fragment);
            }
        }
    }

    public Set<URL> find() {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        try {
            this.find(new DefaultResourceFinderCallback(resources));
        }
        catch (Exception e) {
            throw new RuntimeException("Resource discovery failed", e);
        }
        return resources;
    }

    private void scanBundleClassPath(ResourceFinderCallback callback, Bundle bundle) throws Exception {
        BundleDescription desc = new BundleDescription(bundle.getHeaders());
        List<BundleDescription.HeaderEntry> paths = desc.getBundleClassPath();
        if (paths.isEmpty()) {
            this.scanDirectory(callback, bundle, this.prefix);
        } else {
            for (BundleDescription.HeaderEntry path : paths) {
                String name = path.getName();
                if (name.equals(".") || name.equals("/")) {
                    this.scanDirectory(callback, bundle, this.prefix);
                    continue;
                }
                if (name.endsWith(".jar") || name.endsWith(".zip")) {
                    this.scanZip(callback, bundle, name);
                    continue;
                }
                this.scanDirectory(callback, bundle, BundleResourceFinder.addSlash(this.prefix) + name);
            }
        }
    }

    private void scanDirectory(ResourceFinderCallback callback, Bundle bundle, String basePath) throws Exception {
        if (!this.discoveryFilter.directoryDiscoveryRequired(basePath)) {
            return;
        }
        Enumeration e = bundle.findEntries(basePath, "*" + this.suffix, true);
        if (e != null) {
            while (e.hasMoreElements()) {
                callback.foundInDirectory(bundle, basePath, (URL)e.nextElement());
            }
        }
    }

    private void scanZip(ResourceFinderCallback callback, Bundle bundle, String zipName) throws Exception {
        if (!this.discoveryFilter.zipFileDiscoveryRequired(zipName)) {
            return;
        }
        URL zipEntry = bundle.getEntry(zipName);
        if (zipEntry == null) {
            return;
        }
        try {
            ZipEntry entry;
            ZipInputStream in = new ZipInputStream(zipEntry.openStream());
            while ((entry = in.getNextEntry()) != null) {
                String name = entry.getName();
                if (!this.prefixMatches(name) || !this.suffixMatches(name)) continue;
                callback.foundInJar(bundle, zipName, entry, new ZipEntryInputStream(in));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean prefixMatches(String name) {
        if (this.prefix.length() == 0 || this.prefix.equals(".") || this.prefix.equals("/")) {
            return true;
        }
        if (this.prefix.startsWith("/")) {
            return name.startsWith(this.prefix, 1);
        }
        return name.startsWith(this.prefix);
    }

    private boolean suffixMatches(String name) {
        return this.suffix.length() == 0 ? true : name.endsWith(this.suffix);
    }

    private static String addSlash(String name) {
        if (!name.endsWith("/")) {
            name = name + "/";
        }
        return name;
    }

    public static class DummyDiscoveryFilter
    implements ResourceDiscoveryFilter {
        public boolean directoryDiscoveryRequired(String url) {
            return true;
        }

        public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
            return true;
        }

        public boolean zipFileDiscoveryRequired(String url) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultResourceFinderCallback
    implements ResourceFinderCallback {
        private Set<URL> resources;

        public DefaultResourceFinderCallback() {
            this(new LinkedHashSet<URL>());
        }

        public DefaultResourceFinderCallback(Set<URL> resources) {
            this.resources = resources;
        }

        public Set<URL> getResources() {
            return this.resources;
        }

        @Override
        public void foundInDirectory(Bundle bundle, String baseDir, URL url) throws Exception {
            this.resources.add(url);
        }

        @Override
        public void foundInJar(Bundle bundle, String jarName, ZipEntry entry, InputStream in) throws Exception {
            URL jarURL = bundle.getEntry(jarName);
            URL url = new URL("jar:" + jarURL.toString() + "!/" + entry.getName());
            this.resources.add(url);
        }
    }

    public static interface ResourceFinderCallback {
        public void foundInDirectory(Bundle var1, String var2, URL var3) throws Exception;

        public void foundInJar(Bundle var1, String var2, ZipEntry var3, InputStream var4) throws Exception;
    }

    private static class ZipEntryInputStream
    extends FilterInputStream {
        public ZipEntryInputStream(ZipInputStream in) {
            super(in);
        }

        public void close() throws IOException {
        }
    }
}

